/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.management.NotCompliantMBeanException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighAvailabilityBean;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.impl.core.LastTxIdGetter;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.internal.Version;
import org.neo4j.management.ClusterMemberInfo;
import org.neo4j.management.HighAvailability;

public class HighAvailabilityBeanTest {
    private final GraphDatabaseAPI db = (GraphDatabaseAPI)Mockito.mock(HighlyAvailableGraphDatabase.class);
    private final Dependencies dependencies = new Dependencies();
    private final ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
    private final HighAvailabilityBean bean = new HighAvailabilityBean();
    private final LastTxIdGetter lastTxIdGetter = (LastTxIdGetter)Mockito.mock(LastTxIdGetter.class);
    private final LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
    private final ClusterDatabaseInfoProvider dbInfoProvider = new ClusterDatabaseInfoProvider(this.clusterMembers, this.lastTxIdGetter, this.lastUpdateTime);
    private DefaultFileSystemAbstraction fileSystem;
    private KernelData kernelData;
    private HighAvailability haBean;

    @Before
    public void setup() throws NotCompliantMBeanException {
        this.fileSystem = new DefaultFileSystemAbstraction();
        this.kernelData = new TestHighlyAvailableKernelData();
        ManagementData data = new ManagementData((ManagementBeanProvider)this.bean, this.kernelData, ManagementSupport.load());
        Mockito.when((Object)this.db.getDependencyResolver()).thenReturn((Object)this.dependencies);
        this.haBean = (HighAvailability)new HighAvailabilityBean().createMBean(data);
    }

    @After
    public void tearDown() throws IOException {
        this.kernelData.shutdown();
        this.fileSystem.close();
    }

    @Test
    public void shouldPickUpOnLastCommittedTxId() throws Exception {
        long txId = 101L;
        Mockito.when((Object)this.lastTxIdGetter.getLastTxId()).thenReturn((Object)txId, (Object[])new Long[]{txId + 1L});
        Mockito.when((Object)this.clusterMembers.getCurrentMember()).thenReturn((Object)this.clusterMember(1, "master", 1010));
        long reportedTxId = this.haBean.getLastCommittedTxId();
        Assert.assertEquals((long)txId, (long)reportedTxId);
        long nextReportedTxId = this.haBean.getLastCommittedTxId();
        Assert.assertEquals((long)(txId + 1L), (long)nextReportedTxId);
    }

    @Test
    public void shouldPickUpOnLastUpdateTime() throws Exception {
        long updateTime = 123456789L;
        Mockito.when((Object)this.lastUpdateTime.getLastUpdateTime()).thenReturn((Object)0L, (Object[])new Long[]{updateTime, updateTime + 1000L});
        Mockito.when((Object)this.clusterMembers.getCurrentMember()).thenReturn((Object)this.clusterMember(1, "master", 1010));
        String reportedUpdateTime = this.haBean.getLastUpdateTime();
        Assert.assertEquals((Object)"N/A", (Object)reportedUpdateTime);
        String secondReportedUpdateTime = this.haBean.getLastUpdateTime();
        Assert.assertEquals((Object)Format.date((long)updateTime), (Object)secondReportedUpdateTime);
        String thirdReportedTxId = this.haBean.getLastUpdateTime();
        Assert.assertEquals((Object)Format.date((long)(updateTime + 1000L)), (Object)thirdReportedTxId);
    }

    @Test
    public void shouldSeeChangesInClusterMembers() throws Exception {
        Mockito.when((Object)this.clusterMembers.getMembers()).thenReturn(Arrays.asList(this.clusterMember(1, "master", 1137), this.clusterMember(2, "slave", 1138), this.clusterMember(3, "slave", 1139)));
        this.assertMasterAndSlaveInformation(this.haBean.getInstancesInCluster());
        Mockito.when((Object)this.clusterMembers.getMembers()).thenReturn(Arrays.asList(this.clusterMember(1, "slave", 1137), this.clusterMember(2, "master", 1138), this.clusterMember(3, "slave", 1139)));
        for (ClusterMemberInfo info : this.haBean.getInstancesInCluster()) {
            Assert.assertTrue((String)"every instance should be available", (boolean)info.isAvailable());
            Assert.assertTrue((String)"every instances should have at least one role", (info.getRoles().length > 0 ? 1 : 0) != 0);
            if ("master".equals(info.getRoles()[0])) {
                Assert.assertEquals((String)"coordinator should be master", (Object)"master", (Object)info.getHaRole());
            } else {
                Assert.assertEquals((String)"Either master or slave, no other way", (Object)"slave", (Object)info.getRoles()[0]);
                Assert.assertEquals((String)("instance " + info.getInstanceId() + " is cluster slave but HA master"), (Object)"slave", (Object)info.getHaRole());
            }
            for (String uri : info.getUris()) {
                Assert.assertTrue((String)"roles should contain URIs", (uri.startsWith("ha://") || uri.startsWith("backup://") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void shouldSeeLeavingMemberDisappear() throws Exception {
        Mockito.when((Object)this.clusterMembers.getMembers()).thenReturn(Arrays.asList(this.clusterMember(1, "master", 1137), this.clusterMember(2, "slave", 1138), this.clusterMember(3, "slave", 1139)));
        this.assertMasterAndSlaveInformation(this.haBean.getInstancesInCluster());
        Mockito.when((Object)this.clusterMembers.getMembers()).thenReturn(Arrays.asList(this.clusterMember(1, "master", 1137), this.clusterMember(3, "slave", 1139)));
        Assert.assertEquals((long)2L, (long)this.haBean.getInstancesInCluster().length);
    }

    @Test
    public void shouldSeeFailedMembersInMemberList() throws Exception {
        Mockito.when((Object)this.clusterMembers.getMembers()).thenReturn(Arrays.asList(this.clusterMember(1, "master", 1137), this.clusterMember(2, "slave", 1138), this.clusterMember(3, "UNKNOWN", 1139, false)));
        ClusterMemberInfo[] instances = this.haBean.getInstancesInCluster();
        Assert.assertEquals((long)3L, (long)instances.length);
        Assert.assertEquals((long)2L, (long)this.count(instances, ClusterMemberInfo::isAlive));
        Assert.assertEquals((long)2L, (long)this.count(instances, ClusterMemberInfo::isAvailable));
    }

    @Test
    public void shouldPullUpdates() throws Exception {
        UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        this.dependencies.satisfyDependency((Object)updatePuller);
        String result = this.haBean.update();
        ((UpdatePuller)Mockito.verify((Object)updatePuller)).pullUpdates();
        Assert.assertTrue((String)result, (boolean)result.contains("Update completed in"));
    }

    @Test
    public void shouldReportFailedPullUpdates() throws Exception {
        UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        RuntimeException myException = new RuntimeException("My test exception");
        ((UpdatePuller)Mockito.doThrow((Throwable[])new Throwable[]{myException}).when((Object)updatePuller)).pullUpdates();
        this.dependencies.satisfyDependency((Object)updatePuller);
        String result = this.haBean.update();
        ((UpdatePuller)Mockito.verify((Object)updatePuller)).pullUpdates();
        Assert.assertTrue((String)result, (boolean)result.contains(myException.getMessage()));
    }

    private int count(ClusterMemberInfo[] instances, Predicate<ClusterMemberInfo> filter) {
        int count = 0;
        for (ClusterMemberInfo instance : instances) {
            if (!filter.test(instance)) continue;
            ++count;
        }
        return count;
    }

    private ClusterMember clusterMember(int serverId, String role, int port) throws URISyntaxException {
        return this.clusterMember(serverId, role, port, true);
    }

    private ClusterMember clusterMember(int serverId, String role, int port, boolean alive) throws URISyntaxException {
        URI uri = "UNKNOWN".equals(role) ? null : new URI("ha://" + role + ":" + port);
        return new ClusterMember(new InstanceId(serverId), MapUtil.genericMap((Object[])new Object[]{role, uri}), StoreId.DEFAULT, alive);
    }

    private void assertMasterAndSlaveInformation(ClusterMemberInfo[] instancesInCluster) {
        ClusterMemberInfo master = this.member(instancesInCluster, 1);
        Assert.assertEquals((long)1137L, (long)HighAvailabilityBeanTest.getUriForScheme("ha", Iterables.map(URI::create, Arrays.asList(master.getUris()))).getPort());
        Assert.assertEquals((Object)"master", (Object)master.getHaRole());
        ClusterMemberInfo slave = this.member(instancesInCluster, 2);
        Assert.assertEquals((long)1138L, (long)HighAvailabilityBeanTest.getUriForScheme("ha", Iterables.map(URI::create, Arrays.asList(slave.getUris()))).getPort());
        Assert.assertEquals((Object)"slave", (Object)slave.getHaRole());
        Assert.assertTrue((String)"Slave not available", (boolean)slave.isAvailable());
    }

    private static URI getUriForScheme(String scheme, Iterable<URI> uris) {
        return (URI)Iterables.firstOrNull((Iterable)Iterables.filter(item -> item.getScheme().equals(scheme), uris));
    }

    private ClusterMemberInfo member(ClusterMemberInfo[] members, int instanceId) {
        for (ClusterMemberInfo member : members) {
            if (!member.getInstanceId().equals(Integer.toString(instanceId))) continue;
            return member;
        }
        Assert.fail((String)("Couldn't find cluster member with cluster URI port " + instanceId + " among " + Arrays.toString(members)));
        return null;
    }

    private class TestHighlyAvailableKernelData
    extends HighlyAvailableKernelData {
        TestHighlyAvailableKernelData() {
            super(HighAvailabilityBeanTest.this.db, HighAvailabilityBeanTest.this.clusterMembers, HighAvailabilityBeanTest.this.dbInfoProvider, (FileSystemAbstraction)HighAvailabilityBeanTest.this.fileSystem, null, new File("storeDir"), Config.defaults());
        }

        public Version version() {
            return Version.getKernel();
        }

        public GraphDatabaseAPI graphDatabase() {
            return HighAvailabilityBeanTest.this.db;
        }
    }
}

