/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.modeswitch.StatementLocksFactorySwitcher;
import org.neo4j.kernel.ha.lock.SlaveStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;

public class StatementLocksFactorySwitcherTest {
    private StatementLocksFactory configuredLockFactory = (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class);

    @Test
    public void masterStatementLocks() {
        StatementLocksFactorySwitcher switcher = this.getLocksSwitcher();
        StatementLocksFactory masterLocks = switcher.getMasterImpl();
        Assert.assertSame((Object)masterLocks, (Object)this.configuredLockFactory);
    }

    @Test
    public void slaveStatementLocks() {
        StatementLocksFactorySwitcher switcher = this.getLocksSwitcher();
        StatementLocksFactory slaveLocks = switcher.getSlaveImpl();
        Assert.assertThat((Object)slaveLocks, (Matcher)Matchers.instanceOf(SlaveStatementLocksFactory.class));
    }

    private StatementLocksFactorySwitcher getLocksSwitcher() {
        DelegateInvocationHandler invocationHandler = (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class);
        return new StatementLocksFactorySwitcher(invocationHandler, this.configuredLockFactory);
    }
}

