/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.test.ha.ClusterRule;

public class InstanceCatchupIT {
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)new ClusterRule().withSharedSetting(GraphDatabaseSettings.keep_logical_logs, "1 txs")).withSharedSetting(HaSettings.pull_interval, "0ms");

    @Test
    public void slaveCanRecoverIfItFallsBackAfterJoining() throws Throwable {
        String valueReadFromMaster;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase victim = cluster.getAnySlave(slave);
        String valueThatMakesItToVictim = "valueThatMakesItToVictim";
        this.createNode(victim, "key", valueThatMakesItToVictim);
        ClusterManager.RepairKit repairKit = cluster.fail(victim);
        for (int i = 0; i < 10; ++i) {
            this.createNode(master, "key", "valueTheVictimShouldNotSee");
            this.checkPoint(master);
            this.rotateLog(master);
        }
        repairKit.repair();
        boolean success = false;
        long createdNode = -1L;
        while (!success) {
            try {
                createdNode = this.createNode(victim, "key", valueThatMakesItToVictim);
                success = true;
            }
            catch (IllegalStateException | TransientDatabaseFailureException | TransientTransactionFailureException throwable) {}
        }
        try (Transaction tx = master.beginTx();){
            valueReadFromMaster = (String)master.getNodeById(createdNode).getProperty("key");
            tx.success();
        }
        Assert.assertEquals((Object)valueThatMakesItToVictim, (Object)valueReadFromMaster);
    }

    private void rotateLog(HighlyAvailableGraphDatabase db) throws IOException {
        ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
    }

    private void checkPoint(HighlyAvailableGraphDatabase db) throws IOException {
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private long createNode(HighlyAvailableGraphDatabase db, String key, String value) {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            node.setProperty(key, (Object)value);
            tx.success();
        }
        return node.getId();
    }
}

