/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.rule.TestDirectory;

public class HaIPv6ConfigurationIT {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();

    @Test
    public void testClusterWithLocalhostAddresses() throws Throwable {
        int clusterPort = PortAuthority.allocatePort();
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting("::1", clusterPort)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting("::1", clusterPort)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::1", PortAuthority.allocatePort())).setConfig(ClusterSettings.server_id, "1").setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    @Test
    public void testClusterWithLinkLocalAddress() throws Throwable {
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet6Address) || !inetAddress.isLinkLocalAddress()) continue;
                try {
                    if (!inetAddress.isReachable(1000)) continue;
                    this.testWithAddress(inetAddress);
                }
                catch (ConnectException connectException) {}
            }
        }
    }

    private void testWithAddress(InetAddress inetAddress) throws Exception {
        int clusterPort = PortAuthority.allocatePort();
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting(inetAddress.getHostAddress(), clusterPort)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting(inetAddress.getHostAddress(), clusterPort)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::", PortAuthority.allocatePort())).setConfig(ClusterSettings.server_id, "1").setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    @Test
    public void testClusterWithWildcardAddresses() throws Throwable {
        int clusterPort = PortAuthority.allocatePort();
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting("::", clusterPort)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting("::1", clusterPort)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::", PortAuthority.allocatePort())).setConfig(ClusterSettings.server_id, "1").setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    private String ipv6HostPortSetting(String address, int port) {
        return "[" + address + "]:" + port;
    }
}

