/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class LabelIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();
    protected ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() {
        HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = this.cluster.getAnySlave(slave1);
        Label label = Label.label((String)"Person");
        TransactionContinuation txOnSlave1 = LabelIT.createNodeAndKeepTxOpen(slave1, label);
        TransactionContinuation txOnSlave2 = LabelIT.createNodeAndKeepTxOpen(slave2, label);
        LabelIT.commit(txOnSlave1);
        LabelIT.commit(txOnSlave2);
        Assert.assertEquals((long)LabelIT.getLabelId(slave1, label), (long)LabelIT.getLabelId(slave2, label));
    }

    private static long getLabelId(HighlyAvailableGraphDatabase db, Label label) {
        try (Transaction ignore = db.beginTx();){
            ThreadToStatementContextBridge bridge = LabelIT.threadToStatementContextBridgeFrom(db);
            long l = bridge.getKernelTransactionBoundToThisThread(true).tokenRead().nodeLabel(label.name());
            return l;
        }
    }

    private static void commit(TransactionContinuation txc) {
        txc.resume();
        txc.commit();
    }

    private static TransactionContinuation createNodeAndKeepTxOpen(HighlyAvailableGraphDatabase db, Label label) {
        TransactionContinuation txc = new TransactionContinuation(db);
        txc.begin();
        db.createNode(new Label[]{label});
        txc.suspend();
        return txc;
    }

    private static ThreadToStatementContextBridge threadToStatementContextBridgeFrom(HighlyAvailableGraphDatabase db) {
        return (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    private static class TransactionContinuation {
        private final HighlyAvailableGraphDatabase db;
        private KernelTransaction graphDbTx;
        private final ThreadToStatementContextBridge bridge;

        private TransactionContinuation(HighlyAvailableGraphDatabase db) {
            this.db = db;
            this.bridge = LabelIT.threadToStatementContextBridgeFrom(db);
        }

        public void begin() {
            this.db.beginTx();
            this.graphDbTx = this.bridge.getKernelTransactionBoundToThisThread(false);
        }

        public void suspend() {
            this.graphDbTx = this.bridge.getKernelTransactionBoundToThisThread(true);
            this.bridge.unbindTransactionFromCurrentThread();
        }

        public void resume() {
            this.bridge.bindTransactionToCurrentThread(this.graphDbTx);
        }

        public void commit() {
            try {
                this.graphDbTx.close();
            }
            catch (org.neo4j.internal.kernel.api.exceptions.TransactionFailureException e) {
                throw new TransactionFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

