/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.BlockLogReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class TestBlockLogBuffer {
    @Test
    public void onlyOneNonFullBlock() {
        byte[] bytes = new byte[255];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte byteValue = 5;
        int intValue = 1234;
        long longValue = 574853L;
        float floatValue = 304985.5f;
        double doubleValue = 48493.22;
        byte[] bytesValue = new byte[]{1, 5, 2, 6, 3};
        buffer.put(byteValue);
        buffer.putInt(intValue);
        buffer.putLong(longValue);
        buffer.putFloat(floatValue);
        buffer.putDouble(doubleValue);
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        ByteBuffer verificationBuffer = ByteBuffer.wrap(bytes);
        Assert.assertEquals((long)30L, (long)verificationBuffer.get());
        Assert.assertEquals((long)byteValue, (long)verificationBuffer.get());
        Assert.assertEquals((long)intValue, (long)verificationBuffer.getInt());
        Assert.assertEquals((long)longValue, (long)verificationBuffer.getLong());
        Assert.assertEquals((double)floatValue, (double)verificationBuffer.getFloat(), (double)0.0);
        Assert.assertEquals((double)doubleValue, (double)verificationBuffer.getDouble(), (double)0.0);
        byte[] actualBytes = new byte[bytesValue.length];
        verificationBuffer.get(actualBytes);
        Assert.assertThat((Object)actualBytes, new ArrayMatches<byte[]>(bytesValue));
    }

    @Test
    public void readSmallPortions() throws IOException {
        byte[] bytes = new byte[255];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte byteValue = 5;
        int intValue = 1234;
        long longValue = 574853L;
        buffer.put(byteValue);
        buffer.putInt(intValue);
        buffer.putLong(longValue);
        buffer.close();
        BlockLogReader reader = new BlockLogReader(wrappedBuffer);
        ByteBuffer verificationBuffer = ByteBuffer.wrap(new byte[1]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        Assert.assertEquals((long)byteValue, (long)verificationBuffer.get());
        verificationBuffer = ByteBuffer.wrap(new byte[4]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        Assert.assertEquals((long)intValue, (long)verificationBuffer.getInt());
        verificationBuffer = ByteBuffer.wrap(new byte[8]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        Assert.assertEquals((long)longValue, (long)verificationBuffer.getLong());
    }

    @Test
    public void readOnlyOneNonFullBlock() throws IOException {
        byte[] bytes = new byte[255];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte byteValue = 5;
        int intValue = 1234;
        long longValue = 574853L;
        float floatValue = 304985.5f;
        double doubleValue = 48493.22;
        byte[] bytesValue = new byte[]{1, 5, 2, 6, 3};
        buffer.put(byteValue);
        buffer.putInt(intValue);
        buffer.putLong(longValue);
        buffer.putFloat(floatValue);
        buffer.putDouble(doubleValue);
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        BlockLogReader reader = new BlockLogReader(wrappedBuffer);
        ByteBuffer verificationBuffer = ByteBuffer.wrap(new byte[1000]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        Assert.assertEquals((long)byteValue, (long)verificationBuffer.get());
        Assert.assertEquals((long)intValue, (long)verificationBuffer.getInt());
        Assert.assertEquals((long)longValue, (long)verificationBuffer.getLong());
        Assert.assertEquals((double)floatValue, (double)verificationBuffer.getFloat(), (double)0.0);
        Assert.assertEquals((double)doubleValue, (double)verificationBuffer.getDouble(), (double)0.0);
        byte[] actualBytes = new byte[bytesValue.length];
        verificationBuffer.get(actualBytes);
        Assert.assertThat((Object)actualBytes, new ArrayMatches<byte[]>(bytesValue));
    }

    @Test
    public void onlyOneFullBlock() {
        byte[] bytes = new byte[256];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte[] bytesValue = new byte[255];
        bytesValue[0] = 1;
        bytesValue[254] = -1;
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        ByteBuffer verificationBuffer = ByteBuffer.wrap(bytes);
        Assert.assertEquals((long)-1L, (long)verificationBuffer.get());
        byte[] actualBytes = new byte[bytesValue.length];
        verificationBuffer.get(actualBytes);
        Assert.assertThat((Object)actualBytes, new ArrayMatches<byte[]>(bytesValue));
    }

    @Test
    public void readOnlyOneFullBlock() throws Exception {
        byte[] bytes = new byte[256];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte[] bytesValue = new byte[255];
        bytesValue[0] = 1;
        bytesValue[254] = -1;
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        BlockLogReader reader = new BlockLogReader(wrappedBuffer);
        ByteBuffer verificationBuffer = ByteBuffer.wrap(new byte[1000]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        byte[] actualBytes = new byte[bytesValue.length];
        verificationBuffer.get(actualBytes);
        Assert.assertThat((Object)actualBytes, new ArrayMatches<byte[]>(bytesValue));
    }

    @Test
    public void canWriteLargestAtomAfterFillingBuffer() {
        byte[] bytes = new byte[300];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte[] bytesValue = new byte[255];
        bytesValue[0] = 1;
        bytesValue[254] = -1;
        long longValue = 123456L;
        buffer.put(bytesValue, bytesValue.length);
        buffer.putLong(longValue);
        buffer.close();
        ByteBuffer verificationBuffer = ByteBuffer.wrap(bytes);
        Assert.assertEquals((long)0L, (long)verificationBuffer.get());
        byte[] actualBytes = new byte[bytesValue.length];
        verificationBuffer.get(actualBytes);
        Assert.assertThat((Object)actualBytes, new ArrayMatches<byte[]>(bytesValue));
        Assert.assertEquals((long)8L, (long)verificationBuffer.get());
        Assert.assertEquals((long)longValue, (long)verificationBuffer.getLong());
    }

    @Test
    public void canWriteReallyLargeByteArray() {
        byte[] bytes = new byte[650];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte[] bytesValue = new byte[600];
        bytesValue[1] = 1;
        bytesValue[99] = 2;
        bytesValue[199] = 3;
        bytesValue[299] = 4;
        bytesValue[399] = 5;
        bytesValue[499] = 6;
        bytesValue[599] = 7;
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        ByteBuffer verificationBuffer = ByteBuffer.wrap(bytes);
        Assert.assertEquals((long)0L, (long)verificationBuffer.get());
        byte[] actual = new byte[255];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 0, 255)));
        Assert.assertEquals((long)0L, (long)verificationBuffer.get());
        actual = new byte[255];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 255, 510)));
        Assert.assertEquals((long)90L, (long)verificationBuffer.get());
        actual = new byte[90];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 510, 600)));
    }

    @Test
    public void canReaderReallyLargeByteArray() {
        byte[] bytes = new byte[650];
        ChannelBuffer wrappedBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        wrappedBuffer.resetWriterIndex();
        BlockLogBuffer buffer = new BlockLogBuffer(wrappedBuffer, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        byte[] bytesValue = new byte[600];
        bytesValue[1] = 1;
        bytesValue[99] = 2;
        bytesValue[199] = 3;
        bytesValue[299] = 4;
        bytesValue[399] = 5;
        bytesValue[499] = 6;
        bytesValue[599] = 7;
        buffer.put(bytesValue, bytesValue.length);
        buffer.close();
        BlockLogReader reader = new BlockLogReader(wrappedBuffer);
        ByteBuffer verificationBuffer = ByteBuffer.wrap(new byte[1000]);
        reader.read(verificationBuffer);
        verificationBuffer.flip();
        byte[] actual = new byte[255];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 0, 255)));
        actual = new byte[255];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 255, 510)));
        actual = new byte[90];
        verificationBuffer.get(actual);
        Assert.assertThat((Object)actual, new ArrayMatches<byte[]>(Arrays.copyOfRange(bytesValue, 510, 600)));
    }

    private class ArrayMatches<T>
    extends BaseMatcher<T> {
        private final T expected;
        private Object actual;

        ArrayMatches(T expected) {
            this.expected = expected;
        }

        public boolean matches(Object actual) {
            this.actual = actual;
            if (this.expected instanceof byte[] && actual instanceof byte[]) {
                return Arrays.equals((byte[])actual, (byte[])this.expected);
            }
            if (this.expected instanceof char[] && actual instanceof char[]) {
                return Arrays.equals((char[])actual, (char[])this.expected);
            }
            return false;
        }

        public void describeTo(Description descr) {
            descr.appendText(String.format("expected %s, got %s", this.toString(this.expected), this.toString(this.actual)));
        }

        private String toString(Object value) {
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value) + "; len=" + ((byte[])value).length;
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value) + "; len=" + ((char[])value).length;
            }
            return "" + value;
        }
    }
}

