/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.ha.correctness.ClusterInstance;
import org.neo4j.ha.correctness.ClusterState;
import org.neo4j.ha.correctness.MessageDeliveryAction;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class TestProver {
    @Test
    public void aClusterSnapshotShouldEqualItsOrigin() throws Exception {
        ClusterConfiguration config = new ClusterConfiguration("default", (LogProvider)NullLogProvider.getInstance(), new String[]{"cluster://localhost:5001", "cluster://localhost:5002", "cluster://localhost:5003"});
        ClusterState state = new ClusterState(Arrays.asList(ClusterInstance.newClusterInstance(new InstanceId(1), new URI("cluster://localhost:5001"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance()), ClusterInstance.newClusterInstance(new InstanceId(2), new URI("cluster://localhost:5002"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance()), ClusterInstance.newClusterInstance(new InstanceId(3), new URI("cluster://localhost:5003"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance())), Collections.emptySet());
        ClusterState snapshot = state.snapshot();
        Assert.assertEquals((Object)state, (Object)snapshot);
        Assert.assertEquals((long)state.hashCode(), (long)snapshot.hashCode());
    }

    @Test
    public void twoStatesWithSameSetupAndPendingMessagesShouldBeEqual() throws Exception {
        ClusterConfiguration config = new ClusterConfiguration("default", (LogProvider)NullLogProvider.getInstance(), new String[]{"cluster://localhost:5001", "cluster://localhost:5002", "cluster://localhost:5003"});
        ClusterState state = new ClusterState(Arrays.asList(ClusterInstance.newClusterInstance(new InstanceId(1), new URI("cluster://localhost:5001"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance()), ClusterInstance.newClusterInstance(new InstanceId(2), new URI("cluster://localhost:5002"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance()), ClusterInstance.newClusterInstance(new InstanceId(3), new URI("cluster://localhost:5003"), new Monitors(), config, 10, (LogProvider)NullLogProvider.getInstance())), Collections.emptySet());
        ClusterState firstState = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI("cluster://localhost:5002"), (Object)new Object[]{"defaultcluster", new URI[]{new URI("cluster://localhost:5003")}}).setHeader("conversation-id", "-1").setHeader("from", "cluster://localhost:5002")));
        ClusterState secondState = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI("cluster://localhost:5002"), (Object)new Object[]{"defaultcluster", new URI[]{new URI("cluster://localhost:5003")}}).setHeader("conversation-id", "-1").setHeader("from", "cluster://localhost:5002")));
        Assert.assertEquals((Object)firstState, (Object)secondState);
        Assert.assertEquals((long)firstState.hashCode(), (long)secondState.hashCode());
    }
}

