/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.ha.SlaveTransactionCommitProcess;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.ConstantRequestContextFactory;
import org.neo4j.test.LongResponse;

public class SlaveTransactionCommitProcessTest {
    private AtomicInteger lastSeenEventIdentifier;
    private Master master;
    private RequestContext requestContext;
    private Response<Long> response;
    private PhysicalTransactionRepresentation tx;
    private SlaveTransactionCommitProcess commitProcess;

    @Before
    public void setUp() {
        this.lastSeenEventIdentifier = new AtomicInteger(-1);
        this.master = (Master)Mockito.mock(Master.class);
        this.requestContext = new RequestContext(10L, 11, 12, 13L, 14L);
        ConstantRequestContextFactory reqFactory = new ConstantRequestContextFactory(this.requestContext){

            public RequestContext newRequestContext(int eventIdentifier) {
                SlaveTransactionCommitProcessTest.this.lastSeenEventIdentifier.set(eventIdentifier);
                return super.newRequestContext(eventIdentifier);
            }
        };
        this.response = new LongResponse(42L);
        this.tx = new PhysicalTransactionRepresentation(Collections.emptyList());
        this.tx.setHeader(new byte[0], 1, 1, 1L, 1L, 1L, 1337);
        this.commitProcess = new SlaveTransactionCommitProcess(this.master, (RequestContextFactory)reqFactory);
    }

    @Test
    public void shouldForwardLockIdentifierToMaster() throws Exception {
        Mockito.when((Object)this.master.commit(this.requestContext, (TransactionRepresentation)this.tx)).thenReturn(this.response);
        this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)this.tx), CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
        Assert.assertThat((Object)this.lastSeenEventIdentifier.get(), (Matcher)Matchers.is((Object)1337));
    }

    @Test(expected=TransientTransactionFailureException.class)
    public void mustTranslateComExceptionsToTransientTransactionFailures() throws Exception {
        Mockito.when((Object)this.master.commit(this.requestContext, (TransactionRepresentation)this.tx)).thenThrow(new Throwable[]{new ComException()});
        this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)this.tx), CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
    }
}

