/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.Map;
import java.util.function.LongSupplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.factory.HighlyAvailableEditionModule;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.ha.ClusterRule;

public class UpdatePullerTriggersPageTransactionTrackingIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();
    private final Label NODE_LABEL = Label.label((String)"mark");
    private final TestTransactionVersionContextSupplier contextSupplier = new TestTransactionVersionContextSupplier();
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        CustomGraphDatabaseFactory customGraphDatabaseFactory = new CustomGraphDatabaseFactory();
        this.cluster = ((ClusterRule)this.clusterRule.withSharedSetting(GraphDatabaseSettings.snapshot_query, "true")).withDbFactory(customGraphDatabaseFactory).startCluster();
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        for (int i = 0; i < 3; ++i) {
            try (Transaction tx = master.beginTx();){
                master.createNode(new Label[]{this.NODE_LABEL});
                tx.success();
                continue;
            }
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void updatePullerTriggerPageTransactionTracking() {
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        TransactionIdStore slaveTransactionIdStore = (TransactionIdStore)slave.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        Assert.assertEquals((long)5L, (long)slaveTransactionIdStore.getLastClosedTransactionId());
        ByzantineLongSupplier byzantineIdSupplier = this.contextSupplier.getByzantineIdSupplier();
        byzantineIdSupplier.useWrongTxId();
        try (Transaction ignored = slave.beginTx();){
            slave.execute("match (n) return n");
        }
        catch (QueryExecutionException executionException) {
            Assert.assertEquals((Object)"Unable to get clean data snapshot for query 'match (n) return n' after 5 attempts.", (Object)executionException.getMessage());
        }
        byzantineIdSupplier.useCorrectTxId();
        slave.execute("match (n) return n").close();
    }

    private class ByzantineLongSupplier
    implements LongSupplier {
        private volatile boolean wrongTxId;
        private final LongSupplier originalIdSupplier;

        ByzantineLongSupplier(LongSupplier originalIdSupplier) {
            this.originalIdSupplier = originalIdSupplier;
        }

        @Override
        public long getAsLong() {
            return this.wrongTxId ? 1L : this.originalIdSupplier.getAsLong();
        }

        void useWrongTxId() {
            this.wrongTxId = true;
        }

        void useCorrectTxId() {
            this.wrongTxId = false;
        }
    }

    private class TestTransactionVersionContextSupplier
    extends TransactionVersionContextSupplier {
        private volatile ByzantineLongSupplier byzantineLongSupplier;

        private TestTransactionVersionContextSupplier() {
        }

        public void init(LongSupplier lastClosedTransactionIdSupplier) {
            this.byzantineLongSupplier = new ByzantineLongSupplier(lastClosedTransactionIdSupplier);
            super.init((LongSupplier)this.byzantineLongSupplier);
        }

        public VersionContext getVersionContext() {
            return super.getVersionContext();
        }

        ByzantineLongSupplier getByzantineIdSupplier() {
            return this.byzantineLongSupplier;
        }
    }

    private class CustomFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomFacadeFactory() {
            super(DatabaseInfo.HA, HighlyAvailableEditionModule::new);
        }

        public GraphDatabaseFacade newFacade(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return this.initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)new HighlyAvailableGraphDatabase(storeDir, config, dependencies));
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                protected VersionContextSupplier createCursorContextSupplier(Config config) {
                    return UpdatePullerTriggersPageTransactionTrackingIT.this.contextSupplier;
                }
            };
        }
    }

    private class CustomHighlyAvailableGraphDatabase
    extends HighlyAvailableGraphDatabase {
        CustomHighlyAvailableGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            super(storeDir, config, dependencies);
        }

        protected GraphDatabaseFacadeFactory newHighlyAvailableFacadeFactory() {
            return new CustomFacadeFactory();
        }
    }

    private class CustomGraphDatabaseFactory
    extends TestHighlyAvailableGraphDatabaseFactory {
        private CustomGraphDatabaseFactory() {
        }

        protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Map<String, String> config) {
                    return this.newDatabase(Config.defaults(config));
                }

                public GraphDatabaseService newDatabase(Config config) {
                    config.augment(MapUtil.stringMap((String[])new String[]{"unsupported.dbms.ephemeral", "false"}));
                    return new CustomHighlyAvailableGraphDatabase(storeDir, config, state.databaseDependencies());
                }
            };
        }
    }
}

