/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.MasterTransactionCommitProcess;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;

public class TxPushStrategyConfigIT {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();
    private static final int MASTER = 1;
    private static final int FIRST_SLAVE = 2;
    private static final int SECOND_SLAVE = 3;
    private static final int THIRD_SLAVE = 4;
    private InstanceId[] machineIds;
    private final MissedReplicasMonitor monitorListener = new MissedReplicasMonitor();

    @Test
    public void shouldPushToSlavesInDescendingOrder() {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, HaSettings.TxPushStrategy.fixed_descending);
        for (int i = 0; i < 5; ++i) {
            int missed = this.createTransactionOnMaster(cluster);
            this.assertLastTransactions(cluster, this.lastTx(4, 2L + (long)i, missed));
            this.assertLastTransactions(cluster, this.lastTx(3, 2L + (long)i, missed));
            this.assertLastTransactions(cluster, this.lastTx(2, 1L, missed));
        }
    }

    @Test
    public void shouldPushToSlavesInAscendingOrder() {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, HaSettings.TxPushStrategy.fixed_ascending);
        for (int i = 0; i < 5; ++i) {
            int missed = this.createTransactionOnMaster(cluster);
            this.assertLastTransactions(cluster, this.lastTx(2, 2L + (long)i, missed));
            this.assertLastTransactions(cluster, this.lastTx(3, 2L + (long)i, missed));
            this.assertLastTransactions(cluster, this.lastTx(4, 1L, missed));
        }
    }

    @Test
    public void twoRoundRobin() {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, HaSettings.TxPushStrategy.round_robin);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Monitors monitors = (Monitors)master.getDependencyResolver().resolveDependency(Monitors.class);
        AtomicInteger totalMissedReplicas = new AtomicInteger();
        monitors.addMonitorListener(totalMissedReplicas::addAndGet, new String[0]);
        long txId = this.getLastTx((GraphDatabaseAPI)master);
        int count = 15;
        for (int i = 0; i < count; ++i) {
            this.createTransactionOnMaster(cluster);
        }
        long min = -1L;
        long max = -1L;
        for (GraphDatabaseAPI graphDatabaseAPI : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            long tx = this.getLastTx(graphDatabaseAPI);
            min = min == -1L ? tx : Math.min(min, tx);
            max = max == -1L ? tx : Math.max(max, tx);
        }
        Assert.assertEquals((long)(txId + (long)count), (long)max);
        Assert.assertTrue((String)"There should be members with transactions in the cluster", (min != -1L && max != -1L ? 1 : 0) != 0);
        int minLaggingBehindThreshold = 1 + totalMissedReplicas.get();
        Assert.assertThat((String)("There should at most be a txId gap of 1 among the cluster members since the transaction pushing goes in a round robin fashion. min:" + min + ", max:" + max), (Object)((int)(max - min)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(minLaggingBehindThreshold)));
    }

    @Test
    public void shouldPushToOneLessSlaveOnSlaveCommit() {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, HaSettings.TxPushStrategy.fixed_descending);
        int missed = 0;
        this.assertLastTransactions(cluster, this.lastTx(1, 2L, missed += this.createTransactionOn(cluster, new InstanceId(2))), this.lastTx(2, 2L, missed), this.lastTx(3, 1L, missed), this.lastTx(4, 2L, missed));
        this.assertLastTransactions(cluster, this.lastTx(1, 3L, missed += this.createTransactionOn(cluster, new InstanceId(3))), this.lastTx(2, 2L, missed), this.lastTx(3, 3L, missed), this.lastTx(4, 3L, missed));
        this.assertLastTransactions(cluster, this.lastTx(1, 4L, missed += this.createTransactionOn(cluster, new InstanceId(4))), this.lastTx(2, 2L, missed), this.lastTx(3, 4L, missed), this.lastTx(4, 4L, missed));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveLeavesNicely() {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, HaSettings.TxPushStrategy.fixed_ascending);
        cluster.shutdown(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    @Test
    public void slaveListIsCorrectAfterMasterSwitch() {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, HaSettings.TxPushStrategy.fixed_ascending);
        cluster.shutdown(cluster.getMaster());
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        HighlyAvailableGraphDatabase newMaster = cluster.getMaster();
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        int missed = this.createTransaction(cluster, (GraphDatabaseAPI)newMaster);
        this.assertLastTransactions(cluster, this.lastTx(2, 2L, missed), this.lastTx(3, 2L, missed));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveRageQuits() {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, HaSettings.TxPushStrategy.fixed_ascending);
        cluster.fail(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    private ClusterManager.ManagedCluster startCluster(int memberCount, int pushFactor, HaSettings.TxPushStrategy pushStrategy) {
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withCluster((Supplier)ClusterManager.clusterOfSize(memberCount))).withSharedSetting(HaSettings.tx_push_factor, "" + pushFactor)).withSharedSetting(HaSettings.tx_push_strategy, pushStrategy.name())).startCluster();
        this.mapMachineIds(cluster);
        return cluster;
    }

    private void mapMachineIds(ClusterManager.ManagedCluster cluster) {
        this.machineIds = new InstanceId[cluster.size()];
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        ((Monitors)master.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)this.monitorListener, new String[0]);
        this.machineIds[0] = cluster.getServerId(master);
        ArrayList<HighlyAvailableGraphDatabase> slaves = new ArrayList<HighlyAvailableGraphDatabase>();
        for (HighlyAvailableGraphDatabase hadb : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            if (hadb.isMaster()) continue;
            slaves.add(hadb);
            ((Monitors)hadb.getDependencyResolver().resolveDependency(Monitors.class)).removeMonitorListener((Object)this.monitorListener);
        }
        slaves.sort(Comparator.comparing(cluster::getServerId));
        Iterator iter = slaves.iterator();
        int i = 1;
        while (iter.hasNext()) {
            this.machineIds[i] = cluster.getServerId((HighlyAvailableGraphDatabase)iter.next());
            ++i;
        }
    }

    private void assertLastTransactions(ClusterManager.ManagedCluster cluster, LastTxMapping ... transactionMappings) {
        StringBuilder failures = new StringBuilder();
        for (LastTxMapping mapping : transactionMappings) {
            HighlyAvailableGraphDatabase db = cluster.getMemberByServerId(mapping.serverId);
            mapping.format(failures, this.getLastTx((GraphDatabaseAPI)db));
        }
        Assert.assertTrue((String)failures.toString(), (failures.length() == 0 ? 1 : 0) != 0);
    }

    private long getLastTx(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private LastTxMapping lastTx(int serverIndex, long txId, int missed) {
        InstanceId serverId = this.machineIds[serverIndex - 1];
        return new LastTxMapping(serverId, txId, missed);
    }

    private int createTransactionOnMaster(ClusterManager.ManagedCluster cluster) {
        return this.createTransaction(cluster, (GraphDatabaseAPI)cluster.getMaster());
    }

    private int createTransactionOn(ClusterManager.ManagedCluster cluster, InstanceId serverId) {
        return this.createTransaction(cluster, (GraphDatabaseAPI)cluster.getMemberByServerId(serverId));
    }

    private int createTransaction(final ClusterManager.ManagedCluster cluster, GraphDatabaseAPI db) {
        TransactionTemplate template = new TransactionTemplate().with((GraphDatabaseService)db).retries(10).backoff(1L, TimeUnit.SECONDS).monitor((TransactionTemplate.Monitor)new TransactionTemplate.Monitor.Adapter(){

            public void retrying() {
                System.err.println("Retrying...");
            }

            public void failure(Throwable ex) {
                System.err.println("Attempt failed with " + ex);
                cluster.await(ClusterManager.allSeesAllAsAvailable());
                TxPushStrategyConfigIT.this.mapMachineIds(cluster);
            }
        });
        template.execute(transaction -> {
            this.monitorListener.clear();
            db.createNode();
        });
        return this.monitorListener.missed();
    }

    private static class MissedReplicasMonitor
    implements MasterTransactionCommitProcess.Monitor {
        private int missed;

        private MissedReplicasMonitor() {
        }

        public void missedReplicas(int number) {
            this.missed = number;
        }

        int missed() {
            return this.missed;
        }

        void clear() {
            this.missed = 0;
        }
    }

    private static class LastTxMapping {
        private final InstanceId serverId;
        private final long txId;
        private final int missed;

        LastTxMapping(InstanceId serverId, long txId, int missed) {
            this.serverId = serverId;
            this.txId = txId;
            this.missed = missed;
        }

        public void format(StringBuilder failures, long txId) {
            if (txId < this.txId - (long)this.missed || txId > this.txId) {
                if (failures.length() > 0) {
                    failures.append(", ");
                }
                failures.append(String.format("tx id on server:%d, expected [%d] but was [%d]", this.serverId.toIntegerIndex(), this.txId, txId));
            }
        }
    }
}

