/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class SlaveWritingAfterStoreCopyIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule();

    @Test
    public void shouldHandleSlaveWritingFirstAfterStoryCopy() throws Throwable {
        HashSet<Long> expected = new HashSet<Long>();
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        expected.add(this.createOneNode(master));
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        File slaveStoreDirectory = cluster.getStoreDir(slave);
        ClusterManager.RepairKit shutdownSlave = cluster.shutdown(slave);
        FileUtils.deleteRecursively((File)slaveStoreDirectory);
        slave = shutdownSlave.repair();
        expected.add(this.createOneNode(slave));
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        Assert.assertTrue((boolean)expected.equals(this.collectIds(master)));
        Assert.assertTrue((boolean)expected.equals(this.collectIds(slave)));
    }

    private Set<Long> collectIds(HighlyAvailableGraphDatabase db) {
        HashSet<Long> result = new HashSet<Long>();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                result.add(node.getId());
            }
            tx.success();
        }
        return result;
    }

    private long createOneNode(HighlyAvailableGraphDatabase db) {
        long id;
        try (Transaction tx = db.beginTx();){
            id = db.createNode().getId();
            tx.success();
        }
        return id;
    }
}

