/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterUpdatePuller;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.modeswitch.UpdatePullerSwitcher;

public class UpdatePullerSwitcherTest {
    private UpdatePullerSwitcher modeSwitcher;
    private SlaveUpdatePuller slaveUpdatePuller;

    @Before
    public void setUp() {
        DelegateInvocationHandler invocationHandler = (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class);
        PullerFactory pullerFactory = (PullerFactory)Mockito.mock(PullerFactory.class);
        this.slaveUpdatePuller = (SlaveUpdatePuller)Mockito.mock(SlaveUpdatePuller.class);
        Mockito.when((Object)pullerFactory.createSlaveUpdatePuller()).thenReturn((Object)this.slaveUpdatePuller);
        Mockito.when((Object)invocationHandler.setDelegate((Object)this.slaveUpdatePuller)).thenReturn((Object)this.slaveUpdatePuller);
        this.modeSwitcher = new UpdatePullerSwitcher(invocationHandler, pullerFactory);
    }

    @Test
    public void masterUpdatePuller() {
        UpdatePuller masterPuller = this.modeSwitcher.getMasterImpl();
        Assert.assertSame((Object)MasterUpdatePuller.INSTANCE, (Object)masterPuller);
    }

    @Test
    public void slaveUpdatePuller() {
        UpdatePuller updatePuller = this.modeSwitcher.getSlaveImpl();
        Assert.assertSame((Object)this.slaveUpdatePuller, (Object)updatePuller);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.slaveUpdatePuller});
    }

    @Test
    public void switchToPendingTest() {
        this.modeSwitcher.switchToSlave();
        ((SlaveUpdatePuller)Mockito.verify((Object)this.slaveUpdatePuller)).start();
        this.modeSwitcher.switchToSlave();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.slaveUpdatePuller});
        ((SlaveUpdatePuller)inOrder.verify((Object)this.slaveUpdatePuller)).stop();
        ((SlaveUpdatePuller)inOrder.verify((Object)this.slaveUpdatePuller)).start();
    }
}

