/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.com.ComException;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.MasterClient310;
import org.neo4j.kernel.ha.MasterClient320;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class MasterClientResolver
implements MasterClientFactory,
ComExceptionHandler {
    private volatile MasterClientFactory currentFactory;
    private final Map<ProtocolVersion, MasterClientFactory> protocolToFactoryMapping;
    private final Log log;
    private final ResponseUnpacker responseUnpacker;
    private final InvalidEpochExceptionHandler invalidEpochHandler;
    private final Supplier<LogEntryReader<ReadableClosablePositionAwareChannel>> logEntryReader;

    @Override
    public MasterClient instantiate(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, Monitors monitors, StoreId storeId, LifeSupport life) {
        if (this.currentFactory == null) {
            this.assignDefaultFactory();
        }
        MasterClient result = this.currentFactory.instantiate(destinationHostNameOrIp, destinationPort, originHostNameOrIp, monitors, storeId, life);
        result.setComExceptionHandler(this);
        return result;
    }

    public MasterClientResolver(LogProvider logProvider, ResponseUnpacker responseUnpacker, InvalidEpochExceptionHandler invalidEpochHandler, int readTimeoutMillis, int lockReadTimeout, int channels, int chunkSize, Supplier<LogEntryReader<ReadableClosablePositionAwareChannel>> logEntryReader) {
        this.logEntryReader = logEntryReader;
        this.log = logProvider.getLog(this.getClass());
        this.responseUnpacker = responseUnpacker;
        this.invalidEpochHandler = invalidEpochHandler;
        this.protocolToFactoryMapping = new HashMap<ProtocolVersion, MasterClientFactory>(3, 1.0f);
        this.protocolToFactoryMapping.put(MasterClient214.PROTOCOL_VERSION, new F214(logProvider, readTimeoutMillis, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient310.PROTOCOL_VERSION, new F310(logProvider, readTimeoutMillis, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(MasterClient320.PROTOCOL_VERSION, new F320(logProvider, readTimeoutMillis, lockReadTimeout, channels, chunkSize));
    }

    public void handle(ComException exception) {
        exception.traceComException(this.log, "MasterClientResolver.handle");
        if (exception instanceof IllegalProtocolVersionException) {
            this.log.info("Handling " + (Object)((Object)exception) + ", will pick new master client");
            IllegalProtocolVersionException illegalProtocolVersion = (IllegalProtocolVersionException)exception;
            ProtocolVersion requiredProtocolVersion = new ProtocolVersion(illegalProtocolVersion.getReceived(), 2);
            this.getFor(requiredProtocolVersion);
        } else if (exception instanceof InvalidEpochException) {
            this.log.info("Handling " + (Object)((Object)exception) + ", will go to PENDING and ask for election");
            this.invalidEpochHandler.handle();
        } else {
            this.log.debug("Ignoring " + (Object)((Object)exception) + ".");
        }
    }

    private MasterClientFactory getFor(ProtocolVersion protocolVersion) {
        MasterClientFactory candidate = this.protocolToFactoryMapping.get(protocolVersion);
        if (candidate != null) {
            this.currentFactory = candidate;
        }
        return candidate;
    }

    private MasterClientFactory assignDefaultFactory() {
        return this.getFor(MasterClient320.PROTOCOL_VERSION);
    }

    private final class F320
    extends StaticMasterClientFactory {
        private F320(LogProvider logProvider, int readTimeoutMillis, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logProvider, readTimeoutMillis, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, Monitors monitors, StoreId storeId, LifeSupport life) {
            return (MasterClient)life.add((Lifecycle)new MasterClient320(destinationHostNameOrIp, destinationPort, originHostNameOrIp, this.logProvider, storeId, this.readTimeoutMillis, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize, MasterClientResolver.this.responseUnpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, new String[]{MasterClient320.class.getName()}), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, new String[]{MasterClient320.class.getName()}), (LogEntryReader<ReadableClosablePositionAwareChannel>)((LogEntryReader)MasterClientResolver.this.logEntryReader.get())));
        }
    }

    private final class F310
    extends StaticMasterClientFactory {
        private F310(LogProvider logProvider, int readTimeoutMillis, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logProvider, readTimeoutMillis, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, Monitors monitors, StoreId storeId, LifeSupport life) {
            return (MasterClient)life.add((Lifecycle)new MasterClient310(destinationHostNameOrIp, destinationPort, originHostNameOrIp, this.logProvider, storeId, this.readTimeoutMillis, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize, MasterClientResolver.this.responseUnpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, new String[]{MasterClient320.class.getName()}), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, new String[]{MasterClient320.class.getName()}), (LogEntryReader<ReadableClosablePositionAwareChannel>)((LogEntryReader)MasterClientResolver.this.logEntryReader.get())));
        }
    }

    private final class F214
    extends StaticMasterClientFactory {
        private F214(LogProvider logProvider, int readTimeoutMillis, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(logProvider, readTimeoutMillis, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, Monitors monitors, StoreId storeId, LifeSupport life) {
            return (MasterClient)life.add((Lifecycle)new MasterClient214(destinationHostNameOrIp, destinationPort, originHostNameOrIp, this.logProvider, storeId, this.readTimeoutMillis, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize, MasterClientResolver.this.responseUnpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, new String[]{MasterClient320.class.getName()}), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, new String[]{MasterClient320.class.getName()}), (LogEntryReader<ReadableClosablePositionAwareChannel>)((LogEntryReader)MasterClientResolver.this.logEntryReader.get())));
        }
    }

    private static abstract class StaticMasterClientFactory
    implements MasterClientFactory {
        final LogProvider logProvider;
        final int readTimeoutMillis;
        final int lockReadTimeout;
        final int maxConcurrentChannels;
        final int chunkSize;

        StaticMasterClientFactory(LogProvider logProvider, int readTimeoutMillis, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            this.logProvider = logProvider;
            this.readTimeoutMillis = readTimeoutMillis;
            this.lockReadTimeout = lockReadTimeout;
            this.maxConcurrentChannels = maxConcurrentChannels;
            this.chunkSize = chunkSize;
        }
    }
}

