/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.ha.ClusterRule;

public class PullUpdatesIT {
    private static final int PULL_INTERVAL = 100;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Throwable {
        ClusterManager.ManagedCluster cluster = ((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.pull_interval, "100ms")).startCluster();
        cluster.info("### Creating initial dataset");
        long commonNodeId = this.createNodeOnMaster(cluster);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        this.setProperty(master, commonNodeId, 1);
        cluster.info("### Initial dataset created");
        this.awaitPropagation(1, commonNodeId, cluster, new HighlyAvailableGraphDatabase[0]);
        cluster.info("### Shutting down master");
        ClusterManager.RepairKit masterShutdownRK = cluster.shutdown(master);
        cluster.info("### Awaiting new master");
        cluster.await(ClusterManager.masterAvailable(master));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        cluster.info("### Doing a write to master");
        this.setProperty(cluster.getMaster(), commonNodeId, 2);
        this.awaitPropagation(2, commonNodeId, cluster, master);
        cluster.info("### Repairing cluster");
        masterShutdownRK.repair();
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.info("### Awaiting change propagation");
        this.awaitPropagation(2, commonNodeId, cluster, new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void terminatedTransactionDoesNotForceUpdatePulling() {
        int testTxsOnMaster = 42;
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.pull_interval, "0s")).withSharedSetting(HaSettings.tx_push_factor, "0")).startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        PullUpdatesIT.createNodeOn((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        long lastClosedTxIdOnMaster = this.lastClosedTxIdOn((GraphDatabaseAPI)master);
        long lastClosedTxIdOnSlave = this.lastClosedTxIdOn((GraphDatabaseAPI)slave);
        CountDownLatch slaveTxStarted = new CountDownLatch(1);
        CountDownLatch slaveShouldCommit = new CountDownLatch(1);
        AtomicReference slaveTx = new AtomicReference();
        Future<?> slaveCommit = Executors.newSingleThreadExecutor().submit(() -> {
            try (Transaction tx = slave.beginTx();){
                slaveTx.set(tx);
                slaveTxStarted.countDown();
                this.await(slaveShouldCommit);
                tx.success();
            }
        });
        this.await(slaveTxStarted);
        PullUpdatesIT.createNodesOn((GraphDatabaseService)master, testTxsOnMaster);
        Assert.assertNotNull(slaveTx.get());
        ((Transaction)slaveTx.get()).terminate();
        slaveShouldCommit.countDown();
        try {
            slaveCommit.get();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TransientTransactionFailureException.class));
        }
        Assert.assertEquals((long)(lastClosedTxIdOnMaster + (long)testTxsOnMaster), (long)this.lastClosedTxIdOn((GraphDatabaseAPI)master));
        Assert.assertEquals((long)lastClosedTxIdOnSlave, (long)this.lastClosedTxIdOn((GraphDatabaseAPI)slave));
    }

    @Test
    public void pullUpdatesShellAppPullsUpdates() throws Throwable {
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withCluster((Supplier)ClusterManager.clusterOfSize(2))).withSharedSetting(HaSettings.pull_interval, "0")).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(ShellSettings.remote_shell_enabled, "true")).withInstanceSetting(ShellSettings.remote_shell_port, i -> String.valueOf(PortAuthority.allocatePort()))).startCluster();
        long commonNodeId = this.createNodeOnMaster(cluster);
        this.setProperty(cluster.getMaster(), commonNodeId, 1);
        int shellPort = (Integer)((Config)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getDependencyResolver().resolveDependency(Config.class)).get(ShellSettings.remote_shell_port);
        this.callPullUpdatesViaShell(shellPort);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            Assert.assertEquals((Object)1, (Object)slave.getNodeById(commonNodeId).getProperty("i"));
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPullUpdatesOnStartupNoMatterWhat() throws Exception {
        HighlyAvailableGraphDatabase slave = null;
        HighlyAvailableGraphDatabase master = null;
        try {
            long nodeId;
            File testRootDir = this.clusterRule.cleanDirectory("shouldPullUpdatesOnStartupNoMatterWhat");
            File masterDir = new File(testRootDir, "master");
            int masterClusterPort = PortAuthority.allocatePort();
            master = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(masterDir).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + masterClusterPort).setConfig(ClusterSettings.initial_hosts, "localhost:" + masterClusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
            File slaveDir = new File(testRootDir, "slave");
            slave = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(slaveDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(ClusterSettings.initial_hosts, "localhost:" + masterClusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
            final CountDownLatch slaveLeftLatch = new CountDownLatch(1);
            final ClusterClient masterClusterClient = (ClusterClient)master.getDependencyResolver().resolveDependency(ClusterClient.class);
            masterClusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void leftCluster(InstanceId instanceId, URI member) {
                    slaveLeftLatch.countDown();
                    masterClusterClient.removeClusterListener((ClusterListener)this);
                }
            });
            ((LogService)master.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass()).info("SHUTTING DOWN SLAVE");
            slave.shutdown();
            slave = null;
            Assert.assertTrue((String)"Timeout waiting for slave to leave", (boolean)slaveLeftLatch.await(60L, TimeUnit.SECONDS));
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                node.setProperty("from", (Object)"master");
                nodeId = node.getId();
                tx.success();
            }
            slave = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(slaveDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(ClusterSettings.initial_hosts, "localhost:" + masterClusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(HaSettings.pull_interval, "0").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
            slave.beginTx().close();
            tx = slave.beginTx();
            var12_10 = null;
            try {
                Assert.assertEquals((Object)"master", (Object)slave.getNodeById(nodeId).getProperty("from"));
                tx.success();
            }
            catch (Throwable throwable) {
                var12_10 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var12_10 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var12_10.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private long createNodeOnMaster(ClusterManager.ManagedCluster cluster) {
        return PullUpdatesIT.createNodeOn((GraphDatabaseService)cluster.getMaster());
    }

    private static void createNodesOn(GraphDatabaseService db, int count) {
        for (int i = 0; i < count; ++i) {
            PullUpdatesIT.createNodeOn(db);
        }
    }

    private static long createNodeOn(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            long id = db.createNode().getId();
            tx.success();
            long l = id;
            return l;
        }
    }

    private void callPullUpdatesViaShell(int port) throws ShellException {
        ShellClient client = ShellLobby.newClient((int)port);
        client.evaluate("pullupdates");
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void awaitPropagation(int expectedPropertyValue, long nodeId, ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase ... excepts) throws Exception {
        long endTime = System.currentTimeMillis() + 2000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            block12: for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                for (HighlyAvailableGraphDatabase except : excepts) {
                    if (db == except) continue block12;
                }
                try {
                    Transaction tx = db.beginTx();
                    Throwable throwable = null;
                    try {
                        Number value = (Number)db.getNodeById(nodeId).getProperty("i", null);
                        if (value != null && value.intValue() == expectedPropertyValue) continue;
                        ok = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (NotFoundException e) {
                    ok = false;
                }
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    private void setProperty(HighlyAvailableGraphDatabase db, long nodeId, int i) {
        try (Transaction tx = db.beginTx();){
            db.getNodeById(nodeId).setProperty("i", (Object)i);
            tx.success();
        }
    }

    private void await(CountDownLatch latch) {
        try {
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long lastClosedTxIdOn(GraphDatabaseAPI db) {
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }
}

