/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.function.LongSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class OnDiskLastTxIdGetterTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testGetLastTxIdNoFilePresent() {
        OnDiskLastTxIdGetter getter = new OnDiskLastTxIdGetter(() -> 13L);
        Assert.assertEquals((long)13L, (long)getter.getLastTxId());
    }

    @Test
    public void lastTransactionIdIsBaseTxIdWhileNeoStoresAreStopped() {
        StoreFactory storeFactory = new StoreFactory(new File("store"), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = storeFactory.openAllNeoStores(true);
        neoStores.close();
        LongSupplier supplier = () -> neoStores.getMetaDataStore().getLastCommittedTransactionId();
        OnDiskLastTxIdGetter diskLastTxIdGetter = new OnDiskLastTxIdGetter(supplier);
        Assert.assertEquals((long)1L, (long)diskLastTxIdGetter.getLastTxId());
    }
}

