/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.ClusterHelper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.util.TestHelpers;

public class BackupHaIT {
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)new ClusterRule().withSharedSetting(OnlineBackupSettings.online_backup_enabled, "true")).withInstanceSetting(OnlineBackupSettings.online_backup_server, serverId -> ":" + PortAuthority.allocatePort());
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private File backupPath;

    @Before
    public void setup() throws Exception {
        this.backupPath = this.clusterRule.cleanDirectory("backup-db");
        ClusterHelper.createSomeData((GraphDatabaseService)this.clusterRule.startCluster().getMaster());
    }

    @Test
    public void makeSureBackupCanBePerformed() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
        HighlyAvailableGraphDatabase hagdb = cluster.getAllMembers(new HighlyAvailableGraphDatabase[0]).iterator().next();
        HostnamePort address = cluster.getBackupAddress(hagdb);
        String databaseName = "basic";
        Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.backupPath, (String[])BackupHaIT.backupArguments(address.toString(), this.backupPath, databaseName)));
        DbRepresentation afterChange = ClusterHelper.createSomeData((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_enabled, "false").withSetting(GraphDatabaseSettings.active_database, databaseName).build();
        DbRepresentation backupRepresentation = DbRepresentation.of((File)this.backupPath, (Config)config);
        Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
        Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        for (HighlyAvailableGraphDatabase hagdb : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            HostnamePort address = cluster.getBackupAddress(hagdb);
            DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
            String databaseName = "anyinstance";
            Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.backupPath, (String[])BackupHaIT.backupArguments(address.toString(), this.backupPath, databaseName)));
            DbRepresentation afterChange = ClusterHelper.createSomeData((GraphDatabaseService)cluster.getMaster());
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_enabled, "false").withSetting(GraphDatabaseSettings.active_database, databaseName).build();
            DbRepresentation backupRepresentation = DbRepresentation.of((File)this.backupPath, (Config)config);
            Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
            Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
        }
    }

    private static String[] backupArguments(String from, File backupDir, String databaseName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--from=" + from);
        args.add("--cc-report-dir=" + backupDir);
        args.add("--backup-dir=" + backupDir);
        args.add("--name=" + databaseName);
        return args.toArray(new String[args.size()]);
    }
}

