/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.rule.TestDirectory;

public class PullUpdatesAppliedIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private SortedMap<Integer, Configuration> configurations;
    private Map<Integer, HighlyAvailableGraphDatabase> databases;

    @Before
    public void doBefore() {
        this.configurations = this.createConfigurations();
        this.databases = this.startDatabases();
    }

    private SortedMap<Integer, Configuration> createConfigurations() {
        TreeMap<Integer, Configuration> configurations = new TreeMap<Integer, Configuration>();
        IntStream.range(0, 3).forEach(serverId -> {
            int clusterPort = PortAuthority.allocatePort();
            int haPort = PortAuthority.allocatePort();
            File directory = this.testDirectory.directory(Integer.toString(serverId)).getAbsoluteFile();
            configurations.put(serverId, new Configuration(serverId, clusterPort, haPort, directory));
        });
        return configurations;
    }

    private Map<Integer, HighlyAvailableGraphDatabase> startDatabases() {
        HashMap<Integer, HighlyAvailableGraphDatabase> databases = new HashMap<Integer, HighlyAvailableGraphDatabase>();
        for (Configuration configuration : this.configurations.values()) {
            int serverId = configuration.serverId;
            int clusterPort = configuration.clusterPort;
            int haPort = configuration.haPort;
            File directory = configuration.directory;
            int initialHostPort = this.configurations.values().iterator().next().clusterPort;
            HighlyAvailableGraphDatabase hagdb = PullUpdatesAppliedIT.database(serverId, clusterPort, haPort, directory, initialHostPort);
            databases.put(serverId, hagdb);
        }
        for (HighlyAvailableGraphDatabase database : databases.values()) {
            database.isAvailable(5000L);
        }
        return databases;
    }

    @After
    public void doAfter() {
        if (this.databases != null) {
            this.databases.values().stream().filter(Objects::nonNull).forEach(GraphDatabaseFacade::shutdown);
        }
    }

    @Test
    public void testUpdatesAreWrittenToLogBeforeBeingAppliedToStore() throws Exception {
        int serverIdOfMaster = this.getCurrentMaster();
        this.addNode(serverIdOfMaster);
        int serverIdOfDatabaseToKill = this.findSomeoneNotMaster(serverIdOfMaster);
        HighlyAvailableGraphDatabase databaseToKill = this.findDatabase(serverIdOfDatabaseToKill);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final HighlyAvailableGraphDatabase masterDb = this.findDatabase(serverIdOfMaster);
        ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void leftCluster(InstanceId instanceId, URI member) {
                latch1.countDown();
                ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).removeClusterListener((ClusterListener)this);
            }
        });
        databaseToKill.shutdown();
        Assert.assertTrue((String)"Timeout waiting for instance to leave cluster", (boolean)latch1.await(60L, TimeUnit.SECONDS));
        this.addNode(serverIdOfMaster);
        Configuration configuration = (Configuration)this.configurations.get(serverIdOfDatabaseToKill);
        int clusterPort = configuration.clusterPort;
        int haPort = configuration.haPort;
        File storeDirectory = configuration.directory;
        final CountDownLatch latch2 = new CountDownLatch(1);
        ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(InstanceId server) {
                latch2.countDown();
                ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).removeHeartbeatListener((HeartbeatListener)this);
            }
        });
        PullUpdatesAppliedIT.runInOtherJvm(storeDirectory, serverIdOfDatabaseToKill, clusterPort, haPort, ((Configuration)this.configurations.get((Object)Integer.valueOf((int)serverIdOfMaster))).clusterPort);
        Assert.assertTrue((String)"Timeout waiting for instance to fail", (boolean)latch2.await(60L, TimeUnit.SECONDS));
        Thread.sleep(15000L);
        this.restart(serverIdOfDatabaseToKill);
        File databaseDirectory = this.testDirectory.databaseDir(storeDirectory);
        boolean hasBranchedData = new File(databaseDirectory, "branched").listFiles().length > 0;
        Assert.assertFalse((boolean)hasBranchedData);
    }

    private HighlyAvailableGraphDatabase findDatabase(int serverId) {
        return this.databases.get(serverId);
    }

    private int findSomeoneNotMaster(int serverIdOfMaster) {
        return this.databases.keySet().stream().filter(serverId -> serverId != serverIdOfMaster).findAny().orElseThrow(IllegalStateException::new);
    }

    private void restart(int serverId) {
        Configuration configuration = (Configuration)this.configurations.get(serverId);
        int clusterPort = configuration.clusterPort;
        int haPort = configuration.haPort;
        File directory = configuration.directory;
        HighlyAvailableGraphDatabase highlyAvailableGraphDatabase = PullUpdatesAppliedIT.database(serverId, clusterPort, haPort, directory, this.configurations.values().iterator().next().clusterPort);
        this.databases.put(serverId, highlyAvailableGraphDatabase);
    }

    private static HighlyAvailableGraphDatabase database(int serverId, int clusterPort, int haPort, File path, int initialHostPort) {
        return (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + initialHostPort).setConfig(ClusterSettings.server_id, Integer.toString(serverId)).setConfig(HaSettings.ha_server, "localhost:" + haPort).setConfig(HaSettings.pull_interval, "0ms").setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
    }

    private static void runInOtherJvm(File directory, int serverIdOfDatabaseToKill, int clusterPort, int haPort, int initialHostPort) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList("java", "-Djava.awt.headless=true", "-cp", System.getProperty("java.class.path"), PullUpdatesAppliedIT.class.getName()));
        commandLine.add(directory.toString());
        commandLine.add(String.valueOf(serverIdOfDatabaseToKill));
        commandLine.add(String.valueOf(clusterPort));
        commandLine.add(String.valueOf(haPort));
        commandLine.add(String.valueOf(initialHostPort));
        Process p = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]));
        LinkedList<Thread> threads = new LinkedList<Thread>();
        PullUpdatesAppliedIT.launchStreamConsumers(threads, p);
        Thread.sleep(30000L);
        p.destroy();
        for (Thread t : threads) {
            t.join();
        }
    }

    public static void main(String[] args) throws Exception {
        File storePath = new File(args[0]);
        int serverId = Integer.parseInt(args[1]);
        int clusterPort = Integer.parseInt(args[2]);
        int haPort = Integer.parseInt(args[3]);
        int initialHostPort = Integer.parseInt(args[4]);
        HighlyAvailableGraphDatabase hagdb = PullUpdatesAppliedIT.database(serverId, clusterPort, haPort, storePath, initialHostPort);
        ((UpdatePuller)hagdb.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
    }

    private static void launchStreamConsumers(List<Thread> join, Process p) {
        InputStream outStr = p.getInputStream();
        InputStream errStr = p.getErrorStream();
        Thread out = new Thread((Runnable)new StreamConsumer(outStr, (OutputStream)System.out, false));
        join.add(out);
        Thread err = new Thread((Runnable)new StreamConsumer(errStr, (OutputStream)System.err, false));
        join.add(err);
        out.start();
        err.start();
    }

    private void addNode(int serverId) {
        HighlyAvailableGraphDatabase db = this.findDatabase(serverId);
        try (Transaction tx = db.beginTx();){
            db.createNode().getId();
            tx.success();
        }
    }

    private int getCurrentMaster() {
        return (Integer)this.databases.entrySet().stream().filter(entry -> ((HighlyAvailableGraphDatabase)entry.getValue()).isMaster()).findFirst().orElseThrow(() -> new IllegalStateException("no master")).getKey();
    }

    private class Configuration {
        final int serverId;
        final int clusterPort;
        final int haPort;
        final File directory;

        Configuration(int serverId, int clusterPort, int haPort, File directory) {
            this.serverId = serverId;
            this.clusterPort = clusterPort;
            this.haPort = haPort;
            this.directory = directory;
        }
    }
}

