/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class DefaultMasterImplSPI
implements MasterImpl.SPI {
    private static final int ID_GRAB_SIZE = 1000;
    static final String STORE_COPY_CHECKPOINT_TRIGGER = "store copy";
    private final GraphDatabaseAPI graphDb;
    private final TransactionChecksumLookup txChecksumLookup;
    private final FileSystemAbstraction fileSystem;
    private final TokenHolders tokenHolders;
    private final IdGeneratorFactory idGeneratorFactory;
    private final NeoStoreDataSource neoStoreDataSource;
    private final File databaseDirectory;
    private final ResponsePacker responsePacker;
    private final Monitors monitors;
    private final TransactionCommitProcess transactionCommitProcess;
    private final CheckPointer checkPointer;

    public DefaultMasterImplSPI(GraphDatabaseAPI graphDb, FileSystemAbstraction fileSystemAbstraction, Monitors monitors, TokenHolders tokenHolders, IdGeneratorFactory idGeneratorFactory, TransactionCommitProcess transactionCommitProcess, CheckPointer checkPointer, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, NeoStoreDataSource neoStoreDataSource, LogProvider logProvider) {
        this.graphDb = graphDb;
        this.fileSystem = fileSystemAbstraction;
        this.tokenHolders = tokenHolders;
        this.idGeneratorFactory = idGeneratorFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.checkPointer = checkPointer;
        this.neoStoreDataSource = neoStoreDataSource;
        this.databaseDirectory = graphDb.databaseDirectory();
        this.txChecksumLookup = new TransactionChecksumLookup(transactionIdStore, logicalTransactionStore);
        this.responsePacker = new ResponsePacker(logicalTransactionStore, transactionIdStore, () -> ((GraphDatabaseAPI)graphDb).storeId());
        this.monitors = monitors;
        monitors.addMonitorListener((Object)new LoggingStoreCopyServerMonitor(logProvider.getLog(StoreCopyServer.class)), new String[]{StoreCopyServer.class.getName()});
    }

    @Override
    public boolean isAccessible() {
        return this.graphDb.isAvailable(5000L);
    }

    @Override
    public int getOrCreateLabel(String name) {
        return this.tokenHolders.labelTokens().getOrCreateId(name);
    }

    @Override
    public int getOrCreateProperty(String name) {
        return this.tokenHolders.propertyKeyTokens().getOrCreateId(name);
    }

    @Override
    public IdAllocation allocateIds(IdType idType) {
        IdGenerator generator = this.idGeneratorFactory.get(idType);
        return new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
    }

    @Override
    public StoreId storeId() {
        return this.graphDb.storeId();
    }

    @Override
    public long applyPreparedTransaction(TransactionRepresentation preparedTransaction) throws TransactionFailureException {
        return this.transactionCommitProcess.commit(new TransactionToApply(preparedTransaction), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
    }

    @Override
    public Integer createRelationshipType(String name) {
        return this.tokenHolders.relationshipTypeTokens().getOrCreateId(name);
    }

    @Override
    public long getTransactionChecksum(long txId) throws IOException {
        return this.txChecksumLookup.lookup(txId);
    }

    @Override
    public RequestContext flushStoresAndStreamStoreFiles(StoreWriter writer) {
        StoreCopyServer streamer = new StoreCopyServer(this.neoStoreDataSource, this.checkPointer, this.fileSystem, this.databaseDirectory, (StoreCopyServer.Monitor)this.monitors.newMonitor(StoreCopyServer.Monitor.class, new String[]{StoreCopyServer.class.getName()}));
        return streamer.flushStoresAndStreamStoreFiles(STORE_COPY_CHECKPOINT_TRIGGER, writer, false);
    }

    @Override
    public <T> Response<T> packTransactionStreamResponse(RequestContext context, T response) {
        return this.responsePacker.packTransactionStreamResponse(context, response);
    }

    @Override
    public <T> Response<T> packTransactionObligationResponse(RequestContext context, T response) {
        return this.responsePacker.packTransactionObligationResponse(context, response);
    }

    @Override
    public <T> Response<T> packEmptyResponse(T response) {
        return this.responsePacker.packEmptyResponse(response);
    }

    private static class LoggingStoreCopyServerMonitor
    implements StoreCopyServer.Monitor {
        private Log log;

        LoggingStoreCopyServerMonitor(Log log) {
            this.log = log;
        }

        public void startTryCheckPoint(String storeCopyIdentifier) {
            this.log.debug("%s: try to checkpoint before sending store.", new Object[]{storeCopyIdentifier});
        }

        public void finishTryCheckPoint(String storeCopyIdentifier) {
            this.log.debug("%s: checkpoint before sending store completed.", new Object[]{storeCopyIdentifier});
        }

        public void startStreamingStoreFile(File file, String storeCopyIdentifier) {
            this.log.debug("%s: start streaming file %s.", new Object[]{storeCopyIdentifier, file});
        }

        public void finishStreamingStoreFile(File file, String storeCopyIdentifier) {
            this.log.debug("%s: finish streaming file %s.", new Object[]{storeCopyIdentifier, file});
        }

        public void startStreamingStoreFiles(String storeCopyIdentifier) {
            this.log.debug("%s: start streaming store files.", new Object[]{storeCopyIdentifier});
        }

        public void finishStreamingStoreFiles(String storeCopyIdentifier) {
            this.log.debug("%s: finish streaming store files.", new Object[]{storeCopyIdentifier});
        }

        public void startStreamingTransactions(long startTxId, String storeCopyIdentifier) {
            this.log.debug("%s: start streaming transaction starting %d.", new Object[]{storeCopyIdentifier, startTxId});
        }

        public void finishStreamingTransactions(long endTxId, String storeCopyIdentifier) {
            this.log.debug("%s: finish streaming transactions at %d.", new Object[]{storeCopyIdentifier, endTxId});
        }
    }
}

