/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.storecopy.StoreUtil;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.RetryACoupleOfTimesHandler;
import org.neo4j.test.rule.RetryHandler;
import org.neo4j.test.rule.TestDirectory;

public class BranchedDataIT {
    private final LifeRule life = new LifeRule(true);
    private final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.life);

    @Test
    public void migrationOfBranchedDataDirectories() throws Exception {
        long[] timestamps = new long[3];
        for (int i = 0; i < timestamps.length; ++i) {
            this.startDbAndCreateNode();
            timestamps[i] = this.moveAwayToLookLikeOldBranchedDirectory();
            Thread.sleep(1L);
        }
        File storeDirectory = this.directory.directory();
        File databaseDirectory = this.directory.databaseDir();
        int clusterPort = PortAuthority.allocatePort();
        new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDirectory).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.initial_hosts, "localhost:" + clusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase().shutdown();
        for (long timestamp : timestamps) {
            Assert.assertFalse((String)("directory branched-" + timestamp + " still exists."), (boolean)new File(databaseDirectory, "branched-" + timestamp).exists());
            Assert.assertTrue((String)("directory " + timestamp + " is not there"), (boolean)StoreUtil.getBranchedDataDirectory((File)databaseDirectory, (long)timestamp).exists());
        }
    }

    @Test
    public void shouldCopyStoreFromMasterIfBranched() throws Throwable {
        File dir = this.directory.directory();
        ClusterManager clusterManager = (ClusterManager)this.life.add((Lifecycle)((ClusterManager.Builder)new ClusterManager.Builder(dir).withCluster((Supplier)ClusterManager.clusterOfSize(2))).build());
        ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        BranchedDataIT.createNode((GraphDatabaseService)cluster.getMaster(), "A", new Listener[0]);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        File databaseDir = slave.databaseDirectory();
        ClusterManager.RepairKit starter = cluster.shutdown(slave);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        BranchedDataIT.createNode((GraphDatabaseService)master, "B1", new Listener[0]);
        BranchedDataIT.createNode((GraphDatabaseService)master, "C", new Listener[0]);
        BranchedDataIT.createNodeOffline(databaseDir, "B2");
        slave = starter.repair();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        slave.beginTx().close();
    }

    @Test
    public void shouldCopyStoreFromMasterIfBranchedInLiveScenario() throws Throwable {
        File storeDirectory = this.directory.directory();
        ClusterManager clusterManager = (ClusterManager)this.life.add((Lifecycle)((ClusterManager.Builder)new ClusterManager.Builder(storeDirectory).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "0", HaSettings.pull_interval.name(), "0"}))).build());
        ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase thor = cluster.getMaster();
        String indexName = "valhalla";
        BranchedDataIT.createNode((GraphDatabaseService)thor, "A", BranchedDataIT.andIndexInto(indexName));
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        BranchedDataIT.createNode((GraphDatabaseService)thor, "B1", BranchedDataIT.andIndexInto(indexName));
        HighlyAvailableGraphDatabase odin = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        cluster.info(String.format("%n   ==== TAMPERING WITH " + thor + "'s CABLES ====%n", new Object[0]));
        ClusterManager.RepairKit thorRepairKit = cluster.fail(thor);
        cluster.await(ClusterManager.masterAvailable(thor));
        cluster.await(ClusterManager.memberThinksItIsRole(odin, "master"));
        Assert.assertTrue((boolean)odin.isMaster());
        BranchedDataIT.retryOnTransactionFailure((GraphDatabaseService)odin, db -> BranchedDataIT.createNode(db, "B2", BranchedDataIT.andIndexInto(indexName)));
        Set odinLuceneFilesBefore = Iterables.asSet(BranchedDataIT.gatherLuceneFiles(odin, indexName));
        char prefix = 'C';
        while (!BranchedDataIT.changed(odinLuceneFilesBefore, Iterables.asSet(BranchedDataIT.gatherLuceneFiles(odin, indexName)))) {
            char fixedPrefix = prefix;
            BranchedDataIT.retryOnTransactionFailure((GraphDatabaseService)odin, db -> BranchedDataIT.createNodes((GraphDatabaseService)odin, String.valueOf(fixedPrefix), 10000, BranchedDataIT.andIndexInto(indexName)));
            cluster.force(new HighlyAvailableGraphDatabase[0]);
            prefix = (char)(prefix + '\u0001');
        }
        cluster.info(String.format("%n   ==== REPAIRING CABLES ====%n", new Object[0]));
        cluster.await(ClusterManager.memberThinksItIsRole(thor, "UNKNOWN"));
        BranchMonitor thorHasBranched = BranchedDataIT.installBranchedDataMonitor(cluster.getMonitorsByDatabase(thor));
        thorRepairKit.repair();
        cluster.await(ClusterManager.memberThinksItIsRole(thor, "slave"));
        cluster.await(ClusterManager.memberThinksItIsRole(odin, "master"));
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertFalse((boolean)thor.isMaster());
        Assert.assertTrue((String)"No store-copy performed", (boolean)thorHasBranched.copyCompleted);
        Assert.assertTrue((String)"Store-copy unsuccessful", (boolean)thorHasBranched.copySuccessful);
        int i = 0;
        while (i < 3) {
            int ii = i++;
            BranchedDataIT.retryOnTransactionFailure((GraphDatabaseService)odin, db -> BranchedDataIT.createNodes((GraphDatabaseService)odin, String.valueOf("" + ii), 10, BranchedDataIT.andIndexInto(indexName)));
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            cluster.force(new HighlyAvailableGraphDatabase[0]);
        }
        Assert.assertFalse((boolean)BranchedDataIT.hasNode((GraphDatabaseService)thor, "B1"));
        Assert.assertTrue((boolean)BranchedDataIT.hasNode((GraphDatabaseService)thor, "B2"));
        Assert.assertTrue((boolean)BranchedDataIT.hasNode((GraphDatabaseService)thor, "C-0"));
        Assert.assertTrue((boolean)BranchedDataIT.hasNode((GraphDatabaseService)thor, "0-0"));
        Assert.assertTrue((boolean)BranchedDataIT.hasNode((GraphDatabaseService)odin, "0-0"));
    }

    private static BranchMonitor installBranchedDataMonitor(Monitors monitors) {
        BranchMonitor monitor = new BranchMonitor();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        return monitor;
    }

    private static void retryOnTransactionFailure(GraphDatabaseService db, Consumer<GraphDatabaseService> tx) {
        DatabaseRule.tx((GraphDatabaseService)db, (RetryHandler)RetryACoupleOfTimesHandler.retryACoupleOfTimesOn((Predicate)RetryACoupleOfTimesHandler.ANY_EXCEPTION), tx);
    }

    private static boolean changed(Set<File> before, Set<File> after) {
        return !before.containsAll(after) && !after.containsAll(before);
    }

    private static Collection<File> gatherLuceneFiles(HighlyAvailableGraphDatabase db, String indexName) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        NeoStoreDataSource ds = (NeoStoreDataSource)db.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        try (ResourceIterator files = ds.listStoreFiles(false);){
            while (files.hasNext()) {
                File file = ((StoreFileMetadata)files.next()).file();
                if (!file.getPath().contains(indexName)) continue;
                result.add(file);
            }
        }
        return result;
    }

    private static Listener<Node> andIndexInto(String indexName) {
        return node -> {
            Index index = node.getGraphDatabase().index().forNodes(indexName);
            for (String key : node.getPropertyKeys()) {
                index.add((PropertyContainer)node, key, node.getProperty(key));
            }
        };
    }

    private static boolean hasNode(GraphDatabaseService db, String nodeName) {
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                if (!nodeName.equals(node.getProperty("name", null))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void createNodeOffline(File storeDir, String name) {
        GraphDatabaseService db = BranchedDataIT.startGraphDatabaseService(storeDir);
        try {
            BranchedDataIT.createNode(db, name, new Listener[0]);
        }
        finally {
            db.shutdown();
        }
    }

    private static void createNode(GraphDatabaseService db, String name, Listener<Node> ... additional) {
        try (Transaction tx = db.beginTx();){
            Node node = BranchedDataIT.createNamedNode(db, name);
            for (Listener<Node> listener : additional) {
                listener.receive((Object)node);
            }
            tx.success();
        }
    }

    private static void createNodes(GraphDatabaseService db, String namePrefix, int count, Listener<Node> ... additional) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < count; ++i) {
                Node node = BranchedDataIT.createNamedNode(db, namePrefix + "-" + i);
                for (Listener<Node> listener : additional) {
                    listener.receive((Object)node);
                }
            }
            tx.success();
        }
    }

    private static Node createNamedNode(GraphDatabaseService db, String name) {
        Node node = db.createNode();
        node.setProperty("name", (Object)name);
        return node;
    }

    private long moveAwayToLookLikeOldBranchedDirectory() throws IOException {
        File dir = this.directory.databaseDir();
        long timestamp = System.currentTimeMillis();
        File branchDir = new File(dir, "branched-" + timestamp);
        Assert.assertTrue((String)("create directory: " + branchDir), (boolean)branchDir.mkdirs());
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            String fileName = file.getName();
            if (fileName.equals("debug.log") || file.getName().startsWith("branched-")) continue;
            FileUtils.renameFile((File)file, (File)new File(branchDir, file.getName()), (CopyOption[])new CopyOption[0]);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDbAndCreateNode() {
        GraphDatabaseService db = BranchedDataIT.startGraphDatabaseService(this.directory.absolutePath());
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private static GraphDatabaseService startGraphDatabaseService(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    private static class BranchMonitor
    implements SwitchToSlave.Monitor {
        private volatile boolean copyCompleted;
        private volatile boolean copySuccessful;

        private BranchMonitor() {
        }

        public void storeCopyCompleted(boolean wasSuccessful) {
            this.copyCompleted = true;
            this.copySuccessful = wasSuccessful;
        }
    }
}

