/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import org.neo4j.com.storecopy.StoreUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public enum BranchedDataPolicy {
    keep_all{

        @Override
        public void handle(File databaseDirectory, PageCache pageCache, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            File branchedDataDir = StoreUtil.newBranchedDataDir((File)databaseDirectory);
            msgLog.debug("Moving store from " + databaseDirectory + " to " + branchedDataDir);
            StoreUtil.moveAwayDb((File)databaseDirectory, (File)branchedDataDir);
        }
    }
    ,
    keep_last{

        @Override
        public void handle(File databaseDirectory, PageCache pageCache, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            File branchedDataDir = StoreUtil.newBranchedDataDir((File)databaseDirectory);
            msgLog.debug("Moving store from " + databaseDirectory + " to " + branchedDataDir);
            StoreUtil.moveAwayDb((File)databaseDirectory, (File)branchedDataDir);
            File[] files = StoreUtil.getBranchedDataRootDirectory((File)databaseDirectory).listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!StoreUtil.isBranchedDataDirectory((File)file) || file.equals(branchedDataDir)) continue;
                    StoreUtil.deleteRecursive((File)file);
                }
            }
        }
    }
    ,
    keep_none{

        @Override
        public void handle(File databaseDirectory, PageCache pageCache, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            msgLog.debug("Removing store  " + databaseDirectory);
            StoreUtil.cleanStoreDir((File)databaseDirectory);
        }
    };


    public abstract void handle(File var1, PageCache var2, LogService var3) throws IOException;
}

