/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.ServerUtil;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class SwitchToMaster
implements AutoCloseable {
    Function<Locks, ConversationManager> conversationManagerFactory;
    BiFunction<ConversationManager, LifeSupport, Master> masterFactory;
    BiFunction<Master, ConversationManager, MasterServer> masterServerFactory;
    private Log userLog;
    private HaIdGeneratorFactory idGeneratorFactory;
    private Config config;
    private Supplier<SlaveFactory> slaveFactorySupplier;
    private DelegateInvocationHandler<Master> masterDelegateHandler;
    private ClusterMemberAvailability clusterMemberAvailability;
    private Supplier<NeoStoreDataSource> dataSourceSupplier;

    public SwitchToMaster(LogService logService, HaIdGeneratorFactory idGeneratorFactory, Config config, Supplier<SlaveFactory> slaveFactorySupplier, Function<Locks, ConversationManager> conversationManagerFactory, BiFunction<ConversationManager, LifeSupport, Master> masterFactory, BiFunction<Master, ConversationManager, MasterServer> masterServerFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, Supplier<NeoStoreDataSource> dataSourceSupplier) {
        this.conversationManagerFactory = conversationManagerFactory;
        this.masterFactory = masterFactory;
        this.masterServerFactory = masterServerFactory;
        this.userLog = logService.getUserLog(this.getClass());
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.slaveFactorySupplier = slaveFactorySupplier;
        this.masterDelegateHandler = masterDelegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.dataSourceSupplier = dataSourceSupplier;
    }

    public URI switchToMaster(LifeSupport haCommunicationLife, URI me) {
        this.userLog.info("I am %s, moving to master", new Object[]{SwitchToMaster.myId(this.config)});
        this.idGeneratorFactory.switchToMaster();
        NeoStoreDataSource dataSource = this.dataSourceSupplier.get();
        dataSource.afterModeSwitch();
        Locks locks = (Locks)dataSource.getDependencyResolver().resolveDependency(Locks.class);
        ConversationManager conversationManager = this.conversationManagerFactory.apply(locks);
        Master master = this.masterFactory.apply(conversationManager, haCommunicationLife);
        MasterServer masterServer = this.masterServerFactory.apply(master, conversationManager);
        haCommunicationLife.add((Lifecycle)masterServer);
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.start();
        URI masterHaURI = SwitchToMaster.getMasterUri(me, masterServer, this.config);
        this.clusterMemberAvailability.memberIsAvailable("master", masterHaURI, dataSource.getStoreId());
        this.userLog.info("I am %s, successfully moved to master", new Object[]{SwitchToMaster.myId(this.config)});
        this.slaveFactorySupplier.get().setStoreId(dataSource.getStoreId());
        return masterHaURI;
    }

    static URI getMasterUri(URI me, MasterServer masterServer, Config config) {
        String hostname = ((HostnamePort)config.get(HaSettings.ha_server)).getHost();
        InetSocketAddress masterSocketAddress = masterServer.getSocketAddress();
        if (hostname == null || SwitchToMaster.isWildcard(hostname)) {
            InetAddress masterAddress = masterSocketAddress.getAddress();
            hostname = masterAddress.isAnyLocalAddress() ? me.getHost() : ServerUtil.getHostString((InetSocketAddress)masterSocketAddress);
            hostname = SwitchToMaster.ensureWrapForIPv6Uri(hostname);
        }
        return URI.create("ha://" + hostname + ":" + masterSocketAddress.getPort() + "?serverId=" + SwitchToMaster.myId(config));
    }

    private static String ensureWrapForIPv6Uri(String hostname) {
        if (hostname.contains(":") && !hostname.contains("[")) {
            hostname = "[" + hostname + "]";
        }
        return hostname;
    }

    private static boolean isWildcard(String hostname) {
        return hostname.contains("0.0.0.0") || hostname.contains("[::]") || hostname.contains("[0:0:0:0:0:0:0:0]");
    }

    private static InstanceId myId(Config config) {
        return (InstanceId)config.get(ClusterSettings.server_id);
    }

    @Override
    public void close() {
        this.userLog = null;
        this.conversationManagerFactory = null;
        this.masterFactory = null;
        this.masterServerFactory = null;
        this.idGeneratorFactory = null;
        this.config = null;
        this.slaveFactorySupplier = null;
        this.masterDelegateHandler = null;
        this.clusterMemberAvailability = null;
        this.dataSourceSupplier = null;
    }
}

