/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.store.ForeignStoreException;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.StoreId;

public class SwitchToSlaveBranchThenCopy
extends SwitchToSlave {
    private final LogService logService;

    public SwitchToSlaveBranchThenCopy(DatabaseLayout databaseLayout, LogService logService, FileSystemAbstraction fileSystemAbstraction, Config config, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, Iterable<KernelExtensionFactory<?>> kernelExtensions, MasterClientResolver masterClientResolver, SwitchToSlave.Monitor monitor, StoreCopyClientMonitor storeCopyMonitor, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, Supplier<DatabaseTransactionStats> transactionStatsSupplier) {
        this(databaseLayout, logService, config, idGeneratorFactory, masterDelegateHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, masterClientResolver, monitor, new StoreCopyClient(databaseLayout, config, kernelExtensions, logService.getUserLogProvider(), fileSystemAbstraction, pageCache, storeCopyMonitor, false), neoDataSourceSupplier, transactionIdStoreSupplier, slaveServerFactory, updatePuller, pageCache, monitors, transactionStatsSupplier);
    }

    SwitchToSlaveBranchThenCopy(DatabaseLayout databaseLayout, LogService logService, Config config, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, MasterClientResolver masterClientResolver, SwitchToSlave.Monitor monitor, StoreCopyClient storeCopyClient, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, Supplier<DatabaseTransactionStats> transactionStatsSupplier) {
        super(idGeneratorFactory, monitors, requestContextFactory, masterDelegateHandler, clusterMemberAvailability, masterClientResolver, monitor, pullerFactory, updatePuller, slaveServerFactory, config, logService, pageCache, databaseLayout, transactionIdStoreSupplier, transactionStatsSupplier, neoDataSourceSupplier, storeCopyClient);
        this.logService = logService;
    }

    @Override
    void checkDataConsistency(MasterClient masterClient, TransactionIdStore txIdStore, StoreId storeId, URI masterUri, URI me, CancellationRequest cancellationRequest) throws Throwable {
        try {
            this.userLog.info("Checking store consistency with master");
            this.checkMyStoreIdAndMastersStoreId(storeId, masterUri);
            this.checkDataConsistencyWithMaster(masterUri, masterClient, storeId, txIdStore);
            this.userLog.info("Store is consistent");
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.userLog.info("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.userLog.info("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (txIdStore.getLastCommittedTransactionId() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id", (Throwable)e);
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
                throw e;
            }
            this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs", (Throwable)e);
            throw new ForeignStoreException(e.getExpected(), e.getEncountered());
        }
    }

    void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        this.stopServices();
        branchPolicy.handle(this.databaseLayout.databaseDirectory(), this.pageCache, this.logService);
    }
}

