/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.time.Duration;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.Client;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreId;

public class SlaveClient
extends Client<Slave>
implements Slave {
    private final InstanceId machineId;

    public SlaveClient(InstanceId machineId, String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, int maxConcurrentChannels, int chunkSize, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, 0x1000000, ((Duration)HaSettings.read_timeout.apply(from -> null)).toMillis(), maxConcurrentChannels, chunkSize, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, byteCounterMonitor, requestMonitor, entryReader);
        this.machineId = machineId;
    }

    @Override
    public Response<Void> pullUpdates(long upToAndIncludingTxId) {
        return this.sendRequest(SlaveRequestType.PULL_UPDATES, RequestContext.EMPTY, buffer -> {
            Protocol.writeString((ChannelBuffer)buffer, (String)"nioneodb");
            buffer.writeLong(upToAndIncludingTxId);
        }, Protocol.VOID_DESERIALIZER);
    }

    public ProtocolVersion getProtocolVersion() {
        return SlaveServer.SLAVE_PROTOCOL_VERSION;
    }

    @Override
    public int getServerId() {
        return this.machineId.toIntegerIndex();
    }

    public static enum SlaveRequestType implements RequestType
    {
        PULL_UPDATES((master, context, input, target) -> {
            Protocol.readString((ChannelBuffer)input);
            return master.pullUpdates(input.readLong());
        }, Protocol.VOID_SERIALIZER);

        private final TargetCaller caller;
        private final ObjectSerializer serializer;

        private SlaveRequestType(TargetCaller caller, ObjectSerializer serializer) {
            this.caller = caller;
            this.serializer = serializer;
        }

        public TargetCaller getTargetCaller() {
            return this.caller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public boolean responseShouldBeUnpacked() {
            return false;
        }
    }
}

