/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.LogProvider;

public class SlaveLockManager
implements Locks {
    private final RequestContextFactory requestContextFactory;
    private final Locks local;
    private final Master master;
    private final AvailabilityGuard availabilityGuard;
    private final LogProvider logProvider;

    public SlaveLockManager(Locks localLocks, RequestContextFactory requestContextFactory, Master master, AvailabilityGuard availabilityGuard, LogProvider logProvider, Config config) {
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.local = localLocks;
        this.master = master;
        this.logProvider = logProvider;
    }

    public Locks.Client newClient() {
        Locks.Client client = this.local.newClient();
        return new SlaveLocksClient(this.master, client, this.local, this.requestContextFactory, this.availabilityGuard, this.logProvider);
    }

    public void accept(Locks.Visitor visitor) {
        this.local.accept(visitor);
    }

    public void close() {
        this.local.close();
    }
}

