/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.timeout.FixedTimeoutStrategy;
import org.neo4j.cluster.timeout.TimeoutStrategy;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.MessageDeliveryAction;
import org.neo4j.helpers.collection.Pair;

class ProverTimeouts
extends Timeouts {
    private final Map<Object, Pair<ProverTimeout, Long>> timeouts;
    private final URI to;
    private long time;

    ProverTimeouts(URI to) {
        super((TimeoutStrategy)new FixedTimeoutStrategy(1L));
        this.to = to;
        this.timeouts = new LinkedHashMap<Object, Pair<ProverTimeout, Long>>();
    }

    private ProverTimeouts(URI to, Map<Object, Pair<ProverTimeout, Long>> timeouts) {
        super((TimeoutStrategy)new FixedTimeoutStrategy(0L));
        this.to = to;
        this.timeouts = new LinkedHashMap<Object, Pair<ProverTimeout, Long>>(timeouts);
    }

    public void addMessageProcessor(MessageProcessor messageProcessor) {
    }

    public void setTimeout(Object key, Message<? extends MessageType> timeoutMessage) {
        long timeout = this.time++;
        this.timeouts.put(key, (Pair<ProverTimeout, Long>)Pair.of((Object)((Object)new ProverTimeout(timeout, (Message<? extends MessageType>)timeoutMessage.setHeader("to", this.to.toASCIIString()).setHeader("from", this.to.toASCIIString()))), (Object)timeout));
    }

    public Message<? extends MessageType> cancelTimeout(Object key) {
        Pair<ProverTimeout, Long> timeout = this.timeouts.remove(key);
        if (timeout != null) {
            return ((ProverTimeout)((Object)timeout.first())).getTimeoutMessage();
        }
        return null;
    }

    public void cancelAllTimeouts() {
        this.timeouts.clear();
    }

    public Map<Object, Timeouts.Timeout> getTimeouts() {
        throw new UnsupportedOperationException();
    }

    public void tick(long time) {
    }

    public ProverTimeouts snapshot() {
        return new ProverTimeouts(this.to, this.timeouts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProverTimeouts that = (ProverTimeouts)((Object)o);
        Iterator<Pair<ProverTimeout, Long>> those = that.timeouts.values().iterator();
        Iterator<Pair<ProverTimeout, Long>> mine = this.timeouts.values().iterator();
        while (mine.hasNext()) {
            if (those.hasNext() && ((ProverTimeout)((Object)those.next().first())).equals(mine.next().first())) continue;
            return false;
        }
        return !those.hasNext();
    }

    public int hashCode() {
        return this.timeouts.hashCode();
    }

    public boolean hasTimeouts() {
        return this.timeouts.size() > 0;
    }

    public ClusterAction pop() {
        Map.Entry<Object, Pair<ProverTimeout, Long>> lowestTimeout = this.nextTimeout();
        this.timeouts.remove(lowestTimeout.getKey());
        return new MessageDeliveryAction(((ProverTimeout)((Object)lowestTimeout.getValue().first())).getTimeoutMessage());
    }

    public ClusterAction peek() {
        Map.Entry<Object, Pair<ProverTimeout, Long>> next = this.nextTimeout();
        if (next != null) {
            return new MessageDeliveryAction(((ProverTimeout)((Object)next.getValue().first())).getTimeoutMessage());
        }
        return null;
    }

    private Map.Entry<Object, Pair<ProverTimeout, Long>> nextTimeout() {
        Map.Entry<Object, Pair<ProverTimeout, Long>> lowestTimeout = null;
        for (Map.Entry<Object, Pair<ProverTimeout, Long>> current : this.timeouts.entrySet()) {
            if (lowestTimeout != null && (Long)((Pair)lowestTimeout.getValue()).other() <= (Long)current.getValue().other()) continue;
            lowestTimeout = current;
        }
        return lowestTimeout;
    }

    class ProverTimeout
    extends Timeouts.Timeout {
        ProverTimeout(long timeout, Message<? extends MessageType> timeoutMessage) {
            super((Timeouts)ProverTimeouts.this, timeout, timeoutMessage);
        }

        public int hashCode() {
            return this.getTimeoutMessage().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            ProverTimeout that = (ProverTimeout)((Object)obj);
            return this.getTimeoutMessage().toString().equals(that.getTimeoutMessage().toString());
        }
    }
}

