/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class HACountsPropagationIT {
    private static final int PULL_INTERVAL = 100;
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withSharedSetting(HaSettings.pull_interval, "100ms");

    @Test
    public void shouldPropagateNodeCountsInHA() throws TransactionFailureException {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (org.neo4j.graphdb.Transaction tx = master.beginTx();){
            master.createNode();
            master.createNode(new Label[]{Label.label((String)"A")});
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            Transaction tx = ((Kernel)db.getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
            Throwable throwable = null;
            try {
                Assert.assertEquals((long)2L, (long)tx.dataRead().countsForNode(-1));
                Assert.assertEquals((long)1L, (long)tx.dataRead().countsForNode(0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    @Test
    public void shouldPropagateRelationshipCountsInHA() throws TransactionFailureException {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (org.neo4j.graphdb.Transaction tx = master.beginTx();){
            Node left = master.createNode();
            Node right = master.createNode(new Label[]{Label.label((String)"A")});
            left.createRelationshipTo(right, RelationshipType.withName((String)"Type"));
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            Transaction tx = ((Kernel)db.getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
            Throwable throwable = null;
            try {
                Assert.assertEquals((long)1L, (long)tx.dataRead().countsForRelationship(-1, -1, -1));
                Assert.assertEquals((long)1L, (long)tx.dataRead().countsForRelationship(-1, -1, 0));
                Assert.assertEquals((long)1L, (long)tx.dataRead().countsForRelationship(-1, 0, -1));
                Assert.assertEquals((long)1L, (long)tx.dataRead().countsForRelationship(-1, 0, 0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }
}

