/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.ha.ClusterRule;

public class HaCountsIT {
    private static final Label LABEL = Label.label((String)"label");
    private static final String PROPERTY_NAME = "prop";
    private static final String PROPERTY_VALUE = "value";
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();
    private ClusterManager.ManagedCluster cluster;
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave1;
    private HighlyAvailableGraphDatabase slave2;

    @Before
    public void setup() {
        this.cluster = this.clusterRule.startCluster();
        this.master = this.cluster.getMaster();
        this.slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.slave2 = this.cluster.getAnySlave(this.slave1);
        this.clearDatabase();
    }

    private void clearDatabase() {
        try (org.neo4j.graphdb.Transaction tx = this.master.beginTx();){
            for (IndexDefinition index : this.master.schema().getIndexes()) {
                index.drop();
            }
            tx.success();
        }
        tx = this.master.beginTx();
        var2_2 = null;
        try {
            for (Node node : this.master.getAllNodes()) {
                for (Relationship relationship : node.getRelationships()) {
                    relationship.delete();
                }
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void shouldUpdateCountsOnSlavesWhenCreatingANodeOnMaster() {
        HaCountsIT.createANode(this.master, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        this.cluster.sync(this.master);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.master);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.slave1);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnMasterAndSlaveWhenCreatingANodeOnSlave() {
        HaCountsIT.createANode(this.slave1, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        this.cluster.sync(this.slave1);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.master);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.slave1);
        HaCountsIT.assertOnNodeCounts(1, 1, LABEL, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnSlavesWhenCreatingAnIndexOnMaster() throws Exception {
        HaCountsIT.createANode(this.master, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        IndexDescriptor schemaIndexDescriptor = HaCountsIT.createAnIndex(this.master, LABEL, PROPERTY_NAME);
        HaCountsIT.awaitOnline(this.master);
        this.cluster.sync(this.master);
        HaCountsIT.awaitOnline(this.slave1);
        HaCountsIT.awaitOnline(this.slave2);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.master);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.slave1);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnClusterWhenCreatingANodeOnSlaveAndAnIndexOnMaster() throws Exception {
        HaCountsIT.createANode(this.slave1, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        IndexDescriptor schemaIndexDescriptor = HaCountsIT.createAnIndex(this.master, LABEL, PROPERTY_NAME);
        HaCountsIT.awaitOnline(this.master);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HaCountsIT.awaitOnline(this.slave1);
        HaCountsIT.awaitOnline(this.slave2);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.master);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.slave1);
        HaCountsIT.assertOnIndexCounts(0, 1, 1, 1, schemaIndexDescriptor, this.slave2);
    }

    private static void createANode(HighlyAvailableGraphDatabase db, Label label, String value, String property) {
        try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label});
            node.setProperty(property, (Object)value);
            tx.success();
        }
    }

    private static IndexDescriptor createAnIndex(HighlyAvailableGraphDatabase db, Label label, String propertyName) throws KernelException {
        try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
            KernelTransaction ktx = HaCountsIT.kernelTransaction(db);
            int labelId = ktx.tokenWrite().labelGetOrCreateForName(label.name());
            int propertyKeyId = ktx.tokenWrite().propertyKeyGetOrCreateForName(propertyName);
            IndexReference index = ktx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}));
            tx.success();
            IndexDescriptor indexDescriptor = (IndexDescriptor)index;
            return indexDescriptor;
        }
    }

    private static void assertOnNodeCounts(int expectedTotalNodes, int expectedLabelledNodes, Label label, HighlyAvailableGraphDatabase db) {
        try (org.neo4j.graphdb.Transaction ignored = db.beginTx();){
            KernelTransaction transaction = HaCountsIT.kernelTransaction(db);
            int labelId = transaction.tokenRead().nodeLabel(label.name());
            Assert.assertEquals((long)expectedTotalNodes, (long)transaction.dataRead().countsForNode(-1));
            Assert.assertEquals((long)expectedLabelledNodes, (long)transaction.dataRead().countsForNode(labelId));
        }
    }

    private static void assertOnIndexCounts(int expectedIndexUpdates, int expectedIndexSize, int expectedUniqueValues, int expectedSampleSize, IndexDescriptor indexDescriptor, HighlyAvailableGraphDatabase db) throws TransactionFailureException, IndexNotFoundKernelException {
        try (Transaction tx = ((Kernel)db.getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            IndexReference indexReference = tx.schemaRead().index(indexDescriptor.schema());
            HaCountsIT.assertDoubleLongEquals(expectedIndexUpdates, expectedIndexSize, tx.schemaRead().indexUpdatesAndSize(indexReference, Registers.newDoubleLongRegister()));
            HaCountsIT.assertDoubleLongEquals(expectedUniqueValues, expectedSampleSize, tx.schemaRead().indexSample(indexReference, Registers.newDoubleLongRegister()));
        }
    }

    private static void assertDoubleLongEquals(int expectedFirst, int expectedSecond, Register.DoubleLongRegister actualValues) {
        String msg = String.format("Expected (%d,%d) but was (%d,%d)", expectedFirst, expectedSecond, actualValues.readFirst(), actualValues.readSecond());
        Assert.assertTrue((String)msg, (boolean)actualValues.hasValues((long)expectedFirst, (long)expectedSecond));
    }

    private static KernelTransaction kernelTransaction(HighlyAvailableGraphDatabase db) {
        return ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    private static void awaitOnline(HighlyAvailableGraphDatabase db) {
        try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(60L, TimeUnit.SECONDS);
            tx.success();
        }
    }
}

