/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.SwitchToSlaveCopyThenBranch;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcherContainer;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcherTest;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.storageengine.api.StoreId;

public class HighAvailabilityMemberStateMachineTest {
    @Test
    public void shouldStartFromPending() {
        HighAvailabilityMemberStateMachine memberStateMachine = this.buildMockedStateMachine();
        Assert.assertThat((Object)memberStateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldMoveToToMasterFromPendingOnMasterElectedForItself() {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        memberListener.coordinatorIsElected(me);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
    }

    @Test
    public void shouldRemainToPendingOnMasterElectedForSomeoneElse() {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        memberListener.coordinatorIsElected(new InstanceId(2));
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldSwitchToToSlaveOnMasterAvailableForSomeoneElse() {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.memberIsAvailable("master", new InstanceId(2), URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        Assert.assertThat((Object)probe.masterIsAvailable, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenInMasterStateLosingQuorumFromTwoInstancesShouldRemainMaster() {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.emptyList(), Collections.singletonList(other));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.coordinatorIsElected(me);
        memberListener.memberIsAvailable("master", me, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        memberListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenInMasterStateLosingQuorumFromThreeInstancesShouldGoToPending() {
        InstanceId me = new InstanceId(1);
        InstanceId other1 = new InstanceId(2);
        InstanceId other2 = new InstanceId(3);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        LinkedList<InstanceId> otherInstances = new LinkedList<InstanceId>();
        otherInstances.add(other1);
        otherInstances.add(other2);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.emptyList(), otherInstances);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.coordinatorIsElected(me);
        memberListener.memberIsAvailable("master", me, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        memberListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityRequirement)ArgumentMatchers.any(AvailabilityRequirement.class));
    }

    @Test
    public void whenInSlaveStateLosingOtherSlaveShouldNotPutInPending() {
        InstanceId me = new InstanceId(1);
        InstanceId master = new InstanceId(2);
        InstanceId otherSlave = new InstanceId(3);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.singletonList(master), Collections.singletonList(otherSlave));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.memberIsAvailable("master", master, URI.create("ha://whatever"), StoreId.DEFAULT);
        memberListener.memberIsAvailable("slave", me, URI.create("ha://whatever3"), StoreId.DEFAULT);
        memberListener.memberIsAvailable("slave", otherSlave, URI.create("ha://whatever2"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        memberListener.memberIsFailed(otherSlave);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenInSlaveStateWith3MemberClusterLosingMasterShouldPutInPending() {
        InstanceId me = new InstanceId(1);
        InstanceId master = new InstanceId(2);
        InstanceId otherSlave = new InstanceId(3);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.singletonList(otherSlave), Collections.singletonList(master));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.coordinatorIsElected(master);
        memberListener.memberIsAvailable("master", master, URI.create("ha://whatever"), StoreId.DEFAULT);
        memberListener.memberIsAvailable("slave", me, URI.create("ha://whatever3"), StoreId.DEFAULT);
        memberListener.memberIsAvailable("slave", otherSlave, URI.create("ha://whatever2"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        memberListener.memberIsFailed(master);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityRequirement)ArgumentMatchers.any(AvailabilityRequirement.class));
    }

    @Test
    public void whenInSlaveStateWith2MemberClusterLosingMasterShouldPutInPending() {
        InstanceId me = new InstanceId(1);
        InstanceId master = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.emptyList(), Collections.singletonList(master));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.coordinatorIsElected(master);
        memberListener.memberIsAvailable("master", master, URI.create("ha://whatever"), StoreId.DEFAULT);
        memberListener.memberIsAvailable("slave", me, URI.create("ha://whatever3"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        memberListener.memberIsFailed(master);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityRequirement)ArgumentMatchers.any(AvailabilityRequirement.class));
    }

    @Test
    public void whenInToMasterStateLosingQuorumShouldPutInPending() {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.emptyList(), Collections.singletonList(other));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.coordinatorIsElected(me);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        memberListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityRequirement)ArgumentMatchers.any(AvailabilityRequirement.class));
    }

    @Test
    public void whenInToSlaveStateLosingQuorumShouldPutInPending() {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = this.mockClusterMembers(me, Collections.emptyList(), Collections.singletonList(other));
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, members, guard);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        HAStateChangeListener probe = new HAStateChangeListener();
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        memberListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        memberListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)probe.instanceDetached, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityRequirement)ArgumentMatchers.any(AvailabilityRequirement.class));
    }

    @Test
    public void whenSlaveOnlyIsElectedStayInPending() {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, true);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        HighAvailabilityMemberStateMachine stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events);
        stateMachine.init();
        ClusterMemberListener memberListener = memberListenerContainer.get();
        memberListener.coordinatorIsElected(me);
        Assert.assertThat((Object)stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void whenHAModeSwitcherSwitchesToSlaveTheOtherModeSwitcherDoNotGetTheOldMasterClient() throws Throwable {
        InstanceId me = new InstanceId(1);
        StoreId storeId = StoreIdTestFactory.newStoreIdForCurrentVersion();
        HighAvailabilityMemberContext context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        Mockito.when((Object)context.getMyId()).thenReturn((Object)me);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        ObservedClusterMembers members = (ObservedClusterMembers)Mockito.mock(ObservedClusterMembers.class);
        ClusterMember masterMember = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)masterMember.getHARole()).thenReturn((Object)"master");
        Mockito.when((Object)masterMember.hasRole("master")).thenReturn((Object)true);
        Mockito.when((Object)masterMember.getInstanceId()).thenReturn((Object)new InstanceId(2));
        Mockito.when((Object)masterMember.getStoreId()).thenReturn((Object)storeId);
        ClusterMember self = new ClusterMember(me);
        Mockito.when((Object)members.getMembers()).thenReturn(Arrays.asList(self, masterMember));
        Mockito.when((Object)members.getCurrentMember()).thenReturn((Object)self);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists((File)ArgumentMatchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)dependencyResolver.resolveDependency(FileSystemAbstraction.class)).thenReturn((Object)fs);
        Mockito.when((Object)dependencyResolver.resolveDependency(Monitors.class)).thenReturn((Object)new Monitors());
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dataSource.getStoreId()).thenReturn((Object)storeId);
        Mockito.when((Object)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).thenReturn((Object)dataSource);
        Mockito.when((Object)dependencyResolver.resolveDependency(TransactionIdStore.class)).thenReturn((Object)new SimpleTransactionIdStore());
        Mockito.when((Object)dependencyResolver.resolveDependency(ObservedClusterMembers.class)).thenReturn((Object)members);
        UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        Mockito.when((Object)updatePuller.tryPullUpdates()).thenReturn((Object)true);
        Mockito.when((Object)dependencyResolver.resolveDependency(UpdatePuller.class)).thenReturn((Object)updatePuller);
        ClusterMemberAvailability clusterMemberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        TriggerableClusterMemberEvents events = new TriggerableClusterMemberEvents();
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine stateMachine = new HighAvailabilityMemberStateMachine(context, guard, members, (ClusterMemberEvents)events, election, (LogProvider)NullLogProvider.getInstance());
        ClusterMembers clusterMembers = new ClusterMembers(members, stateMachine);
        Mockito.when((Object)dependencyResolver.resolveDependency(ClusterMembers.class)).thenReturn((Object)clusterMembers);
        stateMachine.init();
        stateMachine.start();
        final DelegateInvocationHandler handler = new DelegateInvocationHandler(Master.class);
        MasterClientResolver masterClientResolver = (MasterClientResolver)Mockito.mock(MasterClientResolver.class);
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Mockito.when((Object)masterClient.getProtocolVersion()).thenReturn((Object)MasterClient214.PROTOCOL_VERSION);
        Mockito.when((Object)masterClient.handshake(ArgumentMatchers.anyLong(), (StoreId)ArgumentMatchers.any(StoreId.class))).thenReturn((Object)new Response<HandshakeResult>(new HandshakeResult(0L, 42L), storeId, (ResourceReleaser)Mockito.mock(ResourceReleaser.class)){

            public void accept(Response.Handler handler) {
            }

            public boolean hasTransactionsToBeApplied() {
                return false;
            }
        });
        Mockito.when((Object)masterClient.toString()).thenReturn((Object)"TheExpectedMasterClient!");
        Mockito.when((Object)masterClientResolver.instantiate(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), (Monitors)ArgumentMatchers.any(Monitors.class), (StoreId)ArgumentMatchers.any(StoreId.class), (LifeSupport)ArgumentMatchers.any(LifeSupport.class))).thenReturn((Object)masterClient);
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean switchedSuccessfully = new AtomicBoolean();
        SwitchToSlave.Monitor monitor = new SwitchToSlave.Monitor(){

            public void switchToSlaveCompleted(boolean wasSuccessful) {
                switchedSuccessfully.set(wasSuccessful);
                latch.countDown();
            }
        };
        Config config = Config.defaults((Setting)ClusterSettings.server_id, (String)me.toString());
        DatabaseTransactionStats transactionCounters = (DatabaseTransactionStats)Mockito.mock(DatabaseTransactionStats.class);
        Mockito.when((Object)transactionCounters.getNumberOfActiveTransactions()).thenReturn((Object)0L);
        PageCache pageCacheMock = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFileMock = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)pagedFileMock.getLastPageId()).thenReturn((Object)1L);
        Mockito.when((Object)pageCacheMock.map((File)ArgumentMatchers.any(File.class), ArgumentMatchers.anyInt(), new OpenOption[0])).thenReturn((Object)pagedFileMock);
        TransactionIdStore transactionIdStoreMock = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStoreMock.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(0L, 0L, 0L));
        SwitchToSlaveCopyThenBranch switchToSlave = new SwitchToSlaveCopyThenBranch(DatabaseLayout.of((File)new File("")), (LogService)NullLogService.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), config, (HaIdGeneratorFactory)Mockito.mock(HaIdGeneratorFactory.class), handler, (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (PullerFactory)Mockito.mock(PullerFactory.class, (Answer)Mockito.RETURNS_MOCKS), Iterables.empty(), masterClientResolver, monitor, (StoreCopyClientMonitor)new StoreCopyClientMonitor.Adapter(), Suppliers.singleton((Object)dataSource), Suppliers.singleton((Object)transactionIdStoreMock), slave -> {
            SlaveServer mock = (SlaveServer)Mockito.mock(SlaveServer.class);
            Mockito.when((Object)mock.getSocketAddress()).thenReturn((Object)new InetSocketAddress("localhost", 123));
            return mock;
        }, updatePuller, pageCacheMock, (Monitors)Mockito.mock(Monitors.class), () -> transactionCounters);
        ComponentSwitcherContainer switcherContainer = new ComponentSwitcherContainer();
        HighAvailabilityModeSwitcher haModeSwitcher = new HighAvailabilityModeSwitcher((SwitchToSlave)switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, clusterMemberAvailability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), me, (ComponentSwitcher)switcherContainer, HighAvailabilityMemberStateMachineTest.neoStoreDataSourceSupplierMock(), (LogService)NullLogService.getInstance());
        haModeSwitcher.init();
        haModeSwitcher.start();
        haModeSwitcher.listeningAt(URI.create("http://localhost:12345"));
        stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)haModeSwitcher);
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        AbstractComponentSwitcher<Object> otherModeSwitcher = new AbstractComponentSwitcher<Object>((DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class)){

            protected Object getSlaveImpl() {
                Master master = (Master)handler.cement();
                ref.set(master);
                latch.countDown();
                return null;
            }

            protected Object getMasterImpl() {
                return null;
            }
        };
        switcherContainer.add((ComponentSwitcher)otherModeSwitcher);
        events.switchToSlave(me);
        latch.await();
        Assert.assertTrue((String)"mode switch failed", (boolean)switchedSuccessfully.get());
        Master actual = ref.get();
        Assert.assertEquals((Object)masterClient.toString(), (Object)actual.toString());
        stateMachine.stop();
        stateMachine.shutdown();
        haModeSwitcher.stop();
        haModeSwitcher.shutdown();
    }

    private ObservedClusterMembers mockClusterMembers(InstanceId me, List<InstanceId> alive, List<InstanceId> failed) {
        ClusterMember otherMember;
        ObservedClusterMembers members = (ObservedClusterMembers)Mockito.mock(ObservedClusterMembers.class);
        ArrayList<ClusterMember> aliveMembers = new ArrayList<ClusterMember>(alive.size());
        ArrayList<ClusterMember> failedMembers = new ArrayList<ClusterMember>(failed.size());
        for (InstanceId instanceId : alive) {
            otherMember = (ClusterMember)Mockito.mock(ClusterMember.class);
            Mockito.when((Object)otherMember.getInstanceId()).thenReturn((Object)instanceId);
            Mockito.when((Object)otherMember.isAlive()).thenReturn((Object)true);
            aliveMembers.add(otherMember);
        }
        for (InstanceId instanceId : failed) {
            otherMember = (ClusterMember)Mockito.mock(ClusterMember.class);
            Mockito.when((Object)otherMember.getInstanceId()).thenReturn((Object)instanceId);
            Mockito.when((Object)otherMember.isAlive()).thenReturn((Object)false);
            failedMembers.add(otherMember);
        }
        ClusterMember thisMember = new ClusterMember(me);
        aliveMembers.add(thisMember);
        ArrayList<ClusterMember> allMembers = new ArrayList<ClusterMember>();
        allMembers.addAll(aliveMembers);
        allMembers.addAll(failedMembers);
        Mockito.when((Object)members.getMembers()).thenReturn(allMembers);
        Mockito.when((Object)members.getAliveMembers()).thenReturn(aliveMembers);
        return members;
    }

    private static DataSourceManager neoStoreDataSourceSupplierMock() {
        DataSourceManager dataSourceManager = new DataSourceManager();
        dataSourceManager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        return dataSourceManager;
    }

    static ClusterMemberListenerContainer mockAddClusterMemberListener(ClusterMemberEvents events) {
        ClusterMemberListenerContainer listenerContainer = new ClusterMemberListenerContainer();
        ((ClusterMemberEvents)Mockito.doAnswer(invocation -> {
            listenerContainer.set((ClusterMemberListener)invocation.getArgument(0));
            return null;
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)ArgumentMatchers.any());
        return listenerContainer;
    }

    private HighAvailabilityMemberStateMachine buildMockedStateMachine() {
        return new StateMachineBuilder().build();
    }

    private HighAvailabilityMemberStateMachine buildMockedStateMachine(HighAvailabilityMemberContext context, ClusterMemberEvents events) {
        return new StateMachineBuilder().withContext(context).withEvents(events).build();
    }

    private HighAvailabilityMemberStateMachine buildMockedStateMachine(HighAvailabilityMemberContext context, ClusterMemberEvents events, ObservedClusterMembers clusterMembers, AvailabilityGuard guard) {
        return new StateMachineBuilder().withContext(context).withEvents(events).withClusterMembers(clusterMembers).withGuard(guard).build();
    }

    private static class TriggerableClusterMemberEvents
    implements ClusterMemberEvents {
        private ClusterMemberListener listener;

        private TriggerableClusterMemberEvents() {
        }

        public void addClusterMemberListener(ClusterMemberListener listener) {
            this.listener = listener;
        }

        public void removeClusterMemberListener(ClusterMemberListener listener) {
        }

        public void switchToSlave(InstanceId me) {
            InstanceId someOneElseThanMyself = new InstanceId(me.toIntegerIndex() + 1);
            this.listener.memberIsAvailable("master", someOneElseThanMyself, URI.create("cluster://127.0.0.1:2390?serverId=2"), null);
            this.listener.memberIsAvailable("slave", me, null, null);
        }
    }

    static final class HAStateChangeListener
    implements HighAvailabilityMemberListener {
        boolean masterIsElected;
        boolean masterIsAvailable;
        boolean slaveIsAvailable;
        boolean instanceStops;
        boolean instanceDetached;
        HighAvailabilityMemberChangeEvent lastEvent;

        HAStateChangeListener() {
        }

        public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = true;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.instanceDetached = false;
            this.lastEvent = event;
        }

        public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = true;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.instanceDetached = false;
            this.lastEvent = event;
        }

        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = true;
            this.instanceStops = false;
            this.instanceDetached = false;
            this.lastEvent = event;
        }

        public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = true;
            this.instanceDetached = false;
            this.lastEvent = event;
        }

        public void instanceDetached(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.instanceDetached = true;
            this.lastEvent = event;
        }
    }

    static class ClusterMemberListenerContainer {
        private ClusterMemberListener clusterMemberListener;

        ClusterMemberListenerContainer() {
        }

        public ClusterMemberListener get() {
            return this.clusterMemberListener;
        }

        public void set(ClusterMemberListener clusterMemberListener) {
            if (this.clusterMemberListener != null) {
                throw new IllegalStateException("Expected to have only 1 listener, but have more. Defined listener: " + this.clusterMemberListener + ". Newly added listener:" + clusterMemberListener);
            }
            this.clusterMemberListener = clusterMemberListener;
        }
    }

    static class StateMachineBuilder {
        HighAvailabilityMemberContext context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ObservedClusterMembers clusterMembers = (ObservedClusterMembers)Mockito.mock(ObservedClusterMembers.class);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        Election election = (Election)Mockito.mock(Election.class);

        StateMachineBuilder() {
        }

        public StateMachineBuilder withContext(HighAvailabilityMemberContext context) {
            this.context = context;
            return this;
        }

        public StateMachineBuilder withEvents(ClusterMemberEvents events) {
            this.events = events;
            return this;
        }

        public StateMachineBuilder withClusterMembers(ObservedClusterMembers clusterMember) {
            this.clusterMembers = clusterMember;
            return this;
        }

        public StateMachineBuilder withGuard(AvailabilityGuard guard) {
            this.guard = guard;
            return this;
        }

        public StateMachineBuilder withElection(Election election) {
            this.election = election;
            return this;
        }

        public HighAvailabilityMemberStateMachine build() {
            return new HighAvailabilityMemberStateMachine(this.context, this.guard, this.clusterMembers, this.events, this.election, (LogProvider)NullLogProvider.getInstance());
        }
    }
}

