/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.factory.HighlyAvailableEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class HighlyAvailableGraphDatabase
extends GraphDatabaseFacade {
    protected HighlyAvailableEditionModule module;

    public HighlyAvailableGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this.newHighlyAvailableFacadeFactory().initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    public HighlyAvailableGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this.newHighlyAvailableFacadeFactory().initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)this);
    }

    protected GraphDatabaseFacadeFactory newHighlyAvailableFacadeFactory() {
        return new GraphDatabaseFacadeFactory(DatabaseInfo.HA, platformModule -> {
            this.module = new HighlyAvailableEditionModule((PlatformModule)platformModule);
            return this.module;
        });
    }

    public HighAvailabilityMemberState getInstanceState() {
        return this.module.memberStateMachine.getCurrentState();
    }

    public String role() {
        return this.module.members.getCurrentMemberRole();
    }

    public boolean isMaster() {
        return "master".equalsIgnoreCase(this.role());
    }
}

