/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.SlaveLabelTokenCreator;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.TokenCreator;

public class LabelTokenCreatorSwitcher
extends AbstractComponentSwitcher<TokenCreator> {
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final Supplier<Kernel> kernelSupplier;

    public LabelTokenCreatorSwitcher(DelegateInvocationHandler<TokenCreator> delegate, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, Supplier<Kernel> kernelSupplier) {
        super(delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.kernelSupplier = kernelSupplier;
    }

    @Override
    protected TokenCreator getMasterImpl() {
        return new DefaultLabelIdCreator(this.kernelSupplier);
    }

    @Override
    protected TokenCreator getSlaveImpl() {
        return new SlaveLabelTokenCreator(this.master.cement(), this.requestContextFactory);
    }
}

