/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.com.RequestContext;
import org.neo4j.function.Factory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.ConversationSPI;
import org.neo4j.kernel.ha.com.master.Conversation;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.kernel.impl.util.collection.TimedRepository;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.time.Clocks;

public class ConversationManager
extends LifecycleAdapter {
    private static final int DEFAULT_TX_TIMEOUT_ADDITION = 5000;
    private static final int UNFINISHED_CONVERSATION_CLEANUP_DELAY = 1000;
    private final int activityCheckIntervalMillis;
    private final int lockTimeoutAddition;
    private final Config config;
    private final ConversationSPI spi;
    private final Factory<Conversation> conversationFactory = new Factory<Conversation>(){

        public Conversation newInstance() {
            return new Conversation(ConversationManager.this.spi.acquireClient());
        }
    };
    TimedRepository<RequestContext, Conversation> conversations;
    private JobHandle staleReaperJob;

    public ConversationManager(ConversationSPI spi, Config config) {
        this(spi, config, 1000, 5000);
    }

    public ConversationManager(ConversationSPI spi, Config config, int activityCheckIntervalMillis, int lockTimeoutAddition) {
        this.spi = spi;
        this.config = config;
        this.activityCheckIntervalMillis = activityCheckIntervalMillis;
        this.lockTimeoutAddition = lockTimeoutAddition;
    }

    public void start() {
        this.conversations = this.createConversationStore();
        this.staleReaperJob = this.spi.scheduleRecurringJob(Group.SLAVE_LOCKS_TIMEOUT, this.activityCheckIntervalMillis, (Runnable)this.conversations);
    }

    public void stop() {
        this.staleReaperJob.cancel(false);
        this.conversations = null;
    }

    public Conversation acquire(RequestContext context) throws NoSuchEntryException, ConcurrentAccessException {
        return (Conversation)this.conversations.acquire((Object)context);
    }

    public void release(RequestContext context) {
        this.conversations.release((Object)context);
    }

    public void begin(RequestContext context) throws ConcurrentAccessException {
        this.conversations.begin((Object)context);
    }

    public void end(RequestContext context) {
        this.conversations.end((Object)context);
    }

    public Set<RequestContext> getActiveContexts() {
        return this.conversations != null ? this.conversations.keys() : Collections.emptySet();
    }

    public void stop(RequestContext context) {
        Conversation conversation = (Conversation)this.conversations.end((Object)context);
        if (conversation != null && conversation.isActive()) {
            conversation.stop();
        }
    }

    public Conversation acquire() {
        return (Conversation)this.getConversationFactory().newInstance();
    }

    protected TimedRepository<RequestContext, Conversation> createConversationStore() {
        return new TimedRepository(this.getConversationFactory(), this.getConversationReaper(), ((Duration)this.config.get(HaSettings.lock_read_timeout)).toMillis() + (long)this.lockTimeoutAddition, Clocks.systemClock());
    }

    protected Consumer<Conversation> getConversationReaper() {
        return Conversation::close;
    }

    protected Factory<Conversation> getConversationFactory() {
        return this.conversationFactory;
    }
}

