/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentials;

public class DefaultElectionCredentialsTest {
    @Test
    public void testCompareToDifferentTxId() {
        DefaultElectionCredentials highTxId = new DefaultElectionCredentials(3, 12L, false);
        DefaultElectionCredentials mediumTxId = new DefaultElectionCredentials(1, 11L, false);
        DefaultElectionCredentials lowTxId = new DefaultElectionCredentials(2, 10L, false);
        ArrayList<DefaultElectionCredentials> toSort = new ArrayList<DefaultElectionCredentials>(2);
        toSort.add(mediumTxId);
        toSort.add(highTxId);
        toSort.add(lowTxId);
        Collections.sort(toSort);
        Assert.assertEquals(toSort.get(0), (Object)lowTxId);
        Assert.assertEquals(toSort.get(1), (Object)mediumTxId);
        Assert.assertEquals(toSort.get(2), (Object)highTxId);
    }

    @Test
    public void testCompareToSameTxId() {
        DefaultElectionCredentials highSameTxId = new DefaultElectionCredentials(1, 10L, false);
        DefaultElectionCredentials lowSameTxId = new DefaultElectionCredentials(2, 10L, false);
        ArrayList<DefaultElectionCredentials> toSort = new ArrayList<DefaultElectionCredentials>(2);
        toSort.add(highSameTxId);
        toSort.add(lowSameTxId);
        Collections.sort(toSort);
        Assert.assertEquals(toSort.get(0), (Object)lowSameTxId);
        Assert.assertEquals(toSort.get(1), (Object)highSameTxId);
    }

    @Test
    public void testExistingMasterLosesWhenComparedToHigherTxIdHigherId() {
        DefaultElectionCredentials currentMaster = new DefaultElectionCredentials(1, 10L, true);
        DefaultElectionCredentials incoming = new DefaultElectionCredentials(2, 11L, false);
        ArrayList<DefaultElectionCredentials> toSort = new ArrayList<DefaultElectionCredentials>(2);
        toSort.add(currentMaster);
        toSort.add(incoming);
        Collections.sort(toSort);
        Assert.assertEquals(toSort.get(0), (Object)currentMaster);
        Assert.assertEquals(toSort.get(1), (Object)incoming);
    }

    @Test
    public void testExistingMasterWinsWhenComparedToLowerIdSameTxId() {
        DefaultElectionCredentials currentMaster = new DefaultElectionCredentials(2, 10L, true);
        DefaultElectionCredentials incoming = new DefaultElectionCredentials(1, 10L, false);
        ArrayList<DefaultElectionCredentials> toSort = new ArrayList<DefaultElectionCredentials>(2);
        toSort.add(currentMaster);
        toSort.add(incoming);
        Collections.sort(toSort);
        Assert.assertEquals(toSort.get(0), (Object)incoming);
        Assert.assertEquals(toSort.get(1), (Object)currentMaster);
    }

    @Test
    public void testExistingMasterWinsWhenComparedToHigherIdLowerTxId() {
        DefaultElectionCredentials currentMaster = new DefaultElectionCredentials(1, 10L, true);
        DefaultElectionCredentials incoming = new DefaultElectionCredentials(2, 9L, false);
        ArrayList<DefaultElectionCredentials> toSort = new ArrayList<DefaultElectionCredentials>(2);
        toSort.add(currentMaster);
        toSort.add(incoming);
        Collections.sort(toSort);
        Assert.assertEquals(toSort.get(0), (Object)incoming);
        Assert.assertEquals(toSort.get(1), (Object)currentMaster);
    }

    @Test
    public void testEquals() {
        DefaultElectionCredentials sameAsNext = new DefaultElectionCredentials(1, 10L, false);
        DefaultElectionCredentials sameAsPrevious = new DefaultElectionCredentials(1, 10L, false);
        Assert.assertEquals((Object)sameAsNext, (Object)sameAsPrevious);
        Assert.assertEquals((Object)sameAsNext, (Object)sameAsNext);
        DefaultElectionCredentials differentTxIdFromNext = new DefaultElectionCredentials(1, 11L, false);
        DefaultElectionCredentials differentTxIdFromPrevious = new DefaultElectionCredentials(1, 10L, false);
        Assert.assertNotEquals((Object)differentTxIdFromNext, (Object)differentTxIdFromPrevious);
        Assert.assertNotEquals((Object)differentTxIdFromPrevious, (Object)differentTxIdFromNext);
        DefaultElectionCredentials differentURIFromNext = new DefaultElectionCredentials(1, 11L, false);
        DefaultElectionCredentials differentURIFromPrevious = new DefaultElectionCredentials(2, 11L, false);
        Assert.assertNotEquals((Object)differentTxIdFromNext, (Object)differentURIFromPrevious);
        Assert.assertNotEquals((Object)differentTxIdFromPrevious, (Object)differentURIFromNext);
    }
}

