/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SchemaIndexHaIT {
    @ClassRule
    public static DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public ClusterRule clusterRule = new ClusterRule();
    private static final IndexProviderDescriptor CONTROLLED_PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("controlled", "1.0");
    private static final Predicate<GraphDatabaseService> IS_MASTER = item -> item instanceof HighlyAvailableGraphDatabase && ((HighlyAvailableGraphDatabase)item).isMaster();
    private final String key = "key";
    private final Label label = Label.label((String)"label");

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        IndexDefinition index = this.createIndex((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        SchemaIndexHaIT.awaitIndexOnline(index, cluster, data);
    }

    @Test
    public void creatingIndexOnSlaveIsNotAllowed() {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try {
            this.createIndex((GraphDatabaseService)slave);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void indexPopulationJobsShouldContinueThroughRoleSwitch() throws Throwable {
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory();
        ClusterManager.ManagedCluster cluster = ((ClusterRule)this.clusterRule.withDbFactory(dbFactory).withSharedSetting(GraphDatabaseSettings.default_schema_provider, CONTROLLED_PROVIDER_DESCRIPTOR.name())).startCluster();
        HighlyAvailableGraphDatabase firstMaster = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)firstMaster);
        this.createIndex((GraphDatabaseService)firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)firstMaster);
        HighlyAvailableGraphDatabase aSlave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ((UpdatePuller)aSlave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        dbFactory.awaitPopulationStarted((GraphDatabaseService)aSlave);
        cluster.shutdown(firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)aSlave);
        cluster.await(ClusterManager.masterAvailable(firstMaster));
        HighlyAvailableGraphDatabase newMaster = cluster.getMaster();
        Assert.assertEquals((String)"Unexpected new master", (Object)aSlave, (Object)newMaster);
        try (Transaction tx = newMaster.beginTx();){
            IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)newMaster.schema().getIndexes());
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)newMaster, data);
            tx.success();
        }
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            dbFactory.triggerFinish((GraphDatabaseService)db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populatingSchemaIndicesOnMasterShouldBeBroughtOnlineOnSlavesAfterStoreCopy() throws Throwable {
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory(IS_MASTER);
        ClusterManager.ManagedCluster cluster = ((ClusterRule)this.clusterRule.withDbFactory(dbFactory).withSharedSetting(GraphDatabaseSettings.default_schema_provider, NativeLuceneFusionIndexProviderFactory20.DESCRIPTOR.name())).startCluster();
        try {
            IndexDefinition index;
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            ClusterManager.RepairKit slaveDown = this.bringSlaveOfflineAndRemoveStoreFiles(cluster, slave);
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
            this.createIndex((GraphDatabaseService)master);
            dbFactory.awaitPopulationStarted((GraphDatabaseService)master);
            slave = slaveDown.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable(), 180L);
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            dbFactory.triggerFinish((GraphDatabaseService)master);
            try (Transaction tx = master.beginTx();){
                index = (IndexDefinition)Iterables.single((Iterable)master.schema().getIndexes());
                SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)master, data);
                tx.success();
            }
            tx = slave.beginTx();
            var9_8 = null;
            try {
                SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)slave, data);
                tx.success();
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var9_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                dbFactory.triggerFinish((GraphDatabaseService)db);
            }
        }
    }

    @Test
    public void onlineSchemaIndicesOnMasterShouldBeBroughtOnlineOnSlavesAfterStoreCopy() throws Throwable {
        IndexDefinition index;
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory();
        ClusterManager.ManagedCluster cluster = ((ClusterRule)this.clusterRule.withDbFactory(dbFactory).withSharedSetting(GraphDatabaseSettings.default_schema_provider, CONTROLLED_PROVIDER_DESCRIPTOR.name())).startCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable(), 120L);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.proceedAsNormalWithIndexPopulationOnAllSlavesExcept(dbFactory, cluster, slave);
        ClusterManager.RepairKit slaveDown = this.bringSlaveOfflineAndRemoveStoreFiles(cluster, slave);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        this.createIndex((GraphDatabaseService)master);
        dbFactory.awaitPopulationStarted((GraphDatabaseService)master);
        dbFactory.triggerFinish((GraphDatabaseService)master);
        try (Transaction tx = master.beginTx();){
            index = (IndexDefinition)Iterables.single((Iterable)master.schema().getIndexes());
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)master, data);
            tx.success();
        }
        slave = slaveDown.repair();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        dbFactory.triggerFinish((GraphDatabaseService)slave);
        tx = slave.beginTx();
        var9_8 = null;
        try {
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)slave, data);
            tx.success();
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void proceedAsNormalWithIndexPopulationOnAllSlavesExcept(ControlledGraphDatabaseFactory dbFactory, ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase slaveToIgnore) {
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            if (db == slaveToIgnore || db.getInstanceState() != HighAvailabilityMemberState.SLAVE) continue;
            dbFactory.triggerFinish((GraphDatabaseService)db);
        }
    }

    private ClusterManager.RepairKit bringSlaveOfflineAndRemoveStoreFiles(ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase slave) throws IOException {
        ClusterManager.RepairKit slaveDown = cluster.shutdown(slave);
        File databaseDir = slave.databaseLayout().databaseDirectory();
        FileUtils.deleteRecursively((File)databaseDir);
        databaseDir.mkdir();
        return slaveDown;
    }

    private Map<Object, Node> createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            HashMap<Object, Node> result = new HashMap<Object, Node>();
            for (int i = 0; i < 10; ++i) {
                Node node = db.createNode(new Label[]{this.label});
                Integer propertyValue = i;
                node.setProperty("key", (Object)propertyValue);
                result.put(propertyValue, node);
            }
            tx.success();
            HashMap<Object, Node> hashMap = result;
            return hashMap;
        }
    }

    private IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor(this.label).on("key").create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private static void awaitIndexOnline(IndexDefinition index, ClusterManager.ManagedCluster cluster, Map<Object, Node> expectedDdata) throws InterruptedException {
        for (GraphDatabaseService graphDatabaseService : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            SchemaIndexHaIT.awaitIndexOnline(index, graphDatabaseService, expectedDdata);
        }
    }

    private static IndexDefinition reHomedIndexDefinition(GraphDatabaseService db, IndexDefinition definition) {
        for (IndexDefinition candidate : db.schema().getIndexes()) {
            if (!candidate.equals(definition)) continue;
            return candidate;
        }
        throw new NoSuchElementException("New database doesn't have requested index");
    }

    private static void awaitIndexOnline(IndexDefinition requestedIndex, GraphDatabaseService db, Map<Object, Node> expectedData) throws InterruptedException {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = SchemaIndexHaIT.reHomedIndexDefinition(db, requestedIndex);
            long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(120L);
            while (!SchemaIndexHaIT.indexOnline(index, db)) {
                Thread.sleep(1L);
                if (System.currentTimeMillis() <= timeout) continue;
                Assert.fail((String)"Expected index to come online within a reasonable time.");
            }
            SchemaIndexHaIT.assertIndexContents(index, db, expectedData);
            tx.success();
        }
    }

    private static void assertIndexContents(IndexDefinition index, GraphDatabaseService db, Map<Object, Node> expectedData) {
        for (Map.Entry<Object, Node> entry : expectedData.entrySet()) {
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{entry.getValue()}), (Object)Iterators.asUniqueSet((Iterator)db.findNodes((Label)Iterables.single((Iterable)index.getLabels()), (String)Iterables.single((Iterable)index.getPropertyKeys()), entry.getKey())));
        }
    }

    private static boolean indexOnline(IndexDefinition index, GraphDatabaseService db) {
        try {
            return db.schema().getIndexState(index) == Schema.IndexState.ONLINE;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static class ControlledGraphDatabaseFactory
    extends TestHighlyAvailableGraphDatabaseFactory {
        final Map<GraphDatabaseService, IndexProvider> perDbIndexProvider = new ConcurrentHashMap<GraphDatabaseService, IndexProvider>();
        private final KernelExtensionFactory<?> factory;

        ControlledGraphDatabaseFactory() {
            this(Predicates.alwaysTrue());
        }

        private ControlledGraphDatabaseFactory(Predicate<GraphDatabaseService> dbsToControlIndexingOn) {
            this.factory = new ControllingIndexProviderFactory(this.perDbIndexProvider, dbsToControlIndexingOn);
            this.getCurrentState().removeKernelExtensions(kef -> kef.getClass().getSimpleName().contains("IndexProvider"));
            this.getCurrentState().addKernelExtensions(Collections.singletonList(this.factory));
        }

        public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(File file) {
            return super.newEmbeddedDatabaseBuilder(file);
        }

        void awaitPopulationStarted(GraphDatabaseService db) {
            ControlledIndexProvider provider = (ControlledIndexProvider)this.perDbIndexProvider.get(db);
            if (provider != null) {
                provider.latch.waitForAllToStart();
            }
        }

        void triggerFinish(GraphDatabaseService db) {
            ControlledIndexProvider provider = (ControlledIndexProvider)this.perDbIndexProvider.get(db);
            if (provider != null) {
                provider.latch.finish();
            }
        }
    }

    private static class ControllingIndexProviderFactory
    extends KernelExtensionFactory<IndexProviderDependencies> {
        private final Map<GraphDatabaseService, IndexProvider> perDbIndexProvider;
        private final Predicate<GraphDatabaseService> injectLatchPredicate;

        ControllingIndexProviderFactory(Map<GraphDatabaseService, IndexProvider> perDbIndexProvider, Predicate<GraphDatabaseService> injectLatchPredicate) {
            super(ExtensionType.DATABASE, CONTROLLED_PROVIDER_DESCRIPTOR.getKey());
            this.perDbIndexProvider = perDbIndexProvider;
            this.injectLatchPredicate = injectLatchPredicate;
        }

        public Lifecycle newInstance(KernelContext context, IndexProviderDependencies deps) {
            PageCache pageCache = deps.pageCache();
            File databaseDirectory = context.directory();
            DefaultFileSystemAbstraction fs = (DefaultFileSystemAbstraction)fileSystemRule.get();
            IndexProvider.Monitor monitor = IndexProvider.Monitor.EMPTY;
            Config config = deps.config();
            OperationalMode operationalMode = context.databaseInfo().operationalMode;
            RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = deps.recoveryCleanupWorkCollector();
            FusionIndexProvider fusionIndexProvider = NativeLuceneFusionIndexProviderFactory20.create((PageCache)pageCache, (File)databaseDirectory, (FileSystemAbstraction)fs, (IndexProvider.Monitor)monitor, (Config)config, (OperationalMode)operationalMode, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector);
            if (this.injectLatchPredicate.test(deps.db())) {
                ControlledIndexProvider provider = new ControlledIndexProvider((IndexProvider)fusionIndexProvider);
                this.perDbIndexProvider.put(deps.db(), provider);
                return provider;
            }
            return fusionIndexProvider;
        }
    }

    static interface IndexProviderDependencies {
        public GraphDatabaseService db();

        public Config config();

        public PageCache pageCache();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();
    }

    private static class ControlledIndexProvider
    extends IndexProvider {
        private final IndexProvider delegate;
        private final DoubleLatch latch = new DoubleLatch();

        ControlledIndexProvider(IndexProvider delegate) {
            super(CONTROLLED_PROVIDER_DESCRIPTOR, IndexDirectoryStructure.given((IndexDirectoryStructure)delegate.directoryStructure()));
            this.delegate = delegate;
        }

        public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            IndexPopulator populator = this.delegate.getPopulator(descriptor, samplingConfig);
            return new ControlledIndexPopulator(populator, this.latch);
        }

        public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
            return this.delegate.getOnlineAccessor(descriptor, samplingConfig);
        }

        public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
            return this.delegate.getInitialState(descriptor);
        }

        public IndexCapability getCapability() {
            return this.delegate.getCapability();
        }

        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
            return this.delegate.storeMigrationParticipant(fs, pageCache);
        }

        public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
            return this.delegate.getPopulationFailure(descriptor);
        }
    }

    private static class ControlledIndexPopulator
    implements IndexPopulator {
        private final DoubleLatch latch;
        private final IndexPopulator delegate;

        ControlledIndexPopulator(IndexPopulator delegate, DoubleLatch latch) {
            this.delegate = delegate;
            this.latch = latch;
        }

        public void create() {
            this.delegate.create();
        }

        public void drop() {
            this.delegate.drop();
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
            this.delegate.add(updates);
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            this.delegate.verifyDeferredConstraints(nodePropertyAccessor);
        }

        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor) {
            return this.delegate.newPopulatingUpdater(nodePropertyAccessor);
        }

        public void close(boolean populationCompletedSuccessfully) {
            this.delegate.close(populationCompletedSuccessfully);
            Assert.assertTrue((String)"Expected population to succeed :(", (boolean)populationCompletedSuccessfully);
            this.latch.finish();
        }

        public void markAsFailed(String failure) {
            this.delegate.markAsFailed(failure);
        }

        public void includeSample(IndexEntryUpdate<?> update) {
            this.delegate.includeSample(update);
        }

        public IndexSample sampleResult() {
            return this.delegate.sampleResult();
        }
    }
}

