/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.util.CountingJobScheduler;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.CleanupRule;

public class SlaveUpdatePullerTest {
    private final AtomicInteger scheduledJobs = new AtomicInteger();
    private final InstanceId instanceId = new InstanceId(1);
    private final Config config = (Config)Mockito.mock(Config.class);
    private final DatabaseAvailabilityGuard databaseAvailabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
    private final LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
    private final Master master = (Master)Mockito.mock(Master.class, (Answer)Mockito.RETURNS_MOCKS);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final InvalidEpochExceptionHandler invalidEpochHandler = (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class);
    private final SlaveUpdatePuller.Monitor monitor = (SlaveUpdatePuller.Monitor)Mockito.mock(SlaveUpdatePuller.Monitor.class);
    private final JobScheduler jobScheduler = new CountingJobScheduler(this.scheduledJobs, JobSchedulerFactory.createInitialisedScheduler());
    private final SlaveUpdatePuller updatePuller = new SlaveUpdatePuller(this.requestContextFactory, this.master, this.lastUpdateTime, (LogProvider)this.logProvider, this.instanceId, (AvailabilityGuard)this.databaseAvailabilityGuard, this.invalidEpochHandler, this.jobScheduler, this.monitor);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setUp() throws Throwable {
        Mockito.when((Object)this.requestContextFactory.newRequestContext()).thenReturn((Object)new RequestContext(42L, 42, 42, 42L, 42L));
        Mockito.when((Object)this.config.get(HaSettings.pull_interval)).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)this.config.get(ClusterSettings.server_id)).thenReturn((Object)this.instanceId);
        Mockito.when((Object)this.databaseAvailabilityGuard.isAvailable(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.jobScheduler.init();
        this.jobScheduler.start();
        this.updatePuller.start();
    }

    @After
    public void tearDown() throws Throwable {
        this.updatePuller.stop();
        this.jobScheduler.stop();
        this.jobScheduler.shutdown();
    }

    @Test
    public void initialisationMustBeIdempotent() {
        this.updatePuller.start();
        this.updatePuller.start();
        this.updatePuller.start();
        Assert.assertThat((Object)this.scheduledJobs.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void shouldStopPullingAfterStop() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(ArgumentMatchers.anyLong());
        ((DatabaseAvailabilityGuard)Mockito.verify((Object)this.databaseAvailabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(ArgumentMatchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)ArgumentMatchers.any());
        ((SlaveUpdatePuller.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).pulledUpdates(ArgumentMatchers.anyLong());
        this.updatePuller.stop();
        this.updatePuller.pullUpdates();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.databaseAvailabilityGuard});
    }

    @Test
    public void keepPullingUpdatesOnConsecutiveCalls() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(ArgumentMatchers.anyLong());
        ((DatabaseAvailabilityGuard)Mockito.verify((Object)this.databaseAvailabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(ArgumentMatchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)ArgumentMatchers.any());
        ((SlaveUpdatePuller.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).pulledUpdates(ArgumentMatchers.anyLong());
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(ArgumentMatchers.anyLong());
        ((DatabaseAvailabilityGuard)Mockito.verify((Object)this.databaseAvailabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(ArgumentMatchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)ArgumentMatchers.any());
        ((SlaveUpdatePuller.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)2))).pulledUpdates(ArgumentMatchers.anyLong());
    }

    @Test
    public void falseOnTryPullUpdatesOnInactivePuller() throws Throwable {
        this.updatePuller.stop();
        boolean result = this.updatePuller.tryPullUpdates();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldThrowIfPullerInitiallyInactiveStrict() throws Throwable {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.stop();
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{condition});
        }
    }

    @Test
    public void shouldThrowIfPullerBecomesInactiveWhileWaitingStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        Mockito.when((Object)condition.evaluate(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            this.updatePuller.stop();
            return false;
        });
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            ((UpdatePuller.Condition)Mockito.verify((Object)condition)).evaluate(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        }
    }

    @Test
    public void shouldHandleInvalidEpochByNotifyingItsHandler() throws Exception {
        ((Master)Mockito.doThrow(InvalidEpochException.class).when((Object)this.master)).pullUpdates((RequestContext)ArgumentMatchers.any(RequestContext.class));
        this.updatePuller.pullUpdates();
        ((InvalidEpochExceptionHandler)Mockito.verify((Object)this.invalidEpochHandler)).handle();
    }

    @Test
    public void shouldCopeWithHardExceptionsLikeOutOfMemory() throws Exception {
        OutOfMemoryError oom = new OutOfMemoryError();
        Mockito.when((Object)this.master.pullUpdates((RequestContext)ArgumentMatchers.any(RequestContext.class))).thenThrow(new Throwable[]{oom}).thenReturn((Object)Response.empty());
        this.updatePuller.pullUpdates();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(SlaveUpdatePuller.class).error(Matchers.any(String.class), Matchers.sameInstance((Object)oom))});
        this.updatePuller.pullUpdates();
    }

    @Test
    public void shouldCapExcessiveComExceptionLogging() throws Exception {
        OngoingStubbing updatePullStubbing = Mockito.when((Object)this.master.pullUpdates((RequestContext)ArgumentMatchers.any(RequestContext.class)));
        updatePullStubbing.thenThrow(new Throwable[]{new ComException()});
        for (int i = 0; i < SlaveUpdatePuller.LOG_CAP + 20; ++i) {
            this.updatePuller.pullUpdates();
        }
        this.logProvider.assertContainsThrowablesMatching(0, this.repeat((Throwable)new ComException(), SlaveUpdatePuller.LOG_CAP));
        updatePullStubbing.thenReturn((Object)Response.empty()).thenThrow(new Throwable[]{new ComException()});
        this.updatePuller.pullUpdates();
        this.updatePuller.pullUpdates();
        this.logProvider.assertContainsThrowablesMatching(0, this.repeat((Throwable)new ComException(), SlaveUpdatePuller.LOG_CAP + 1));
    }

    private Throwable[] repeat(Throwable throwable, int count) {
        Throwable[] throwables = new Throwable[count];
        for (int i = 0; i < count; ++i) {
            throwables[i] = throwable;
        }
        return throwables;
    }

    @Test
    public void shouldCapExcessiveInvalidEpochExceptionLogging() throws Exception {
        OngoingStubbing updatePullStubbing = Mockito.when((Object)this.master.pullUpdates((RequestContext)ArgumentMatchers.any(RequestContext.class)));
        updatePullStubbing.thenThrow(new Throwable[]{new InvalidEpochException(2L, 1L)});
        for (int i = 0; i < SlaveUpdatePuller.LOG_CAP + 20; ++i) {
            this.updatePuller.pullUpdates();
        }
        this.logProvider.assertContainsThrowablesMatching(0, this.repeat((Throwable)new InvalidEpochException(2L, 1L), SlaveUpdatePuller.LOG_CAP));
        updatePullStubbing.thenReturn((Object)Response.empty()).thenThrow(new Throwable[]{new InvalidEpochException(2L, 1L)});
        this.updatePuller.pullUpdates();
        this.updatePuller.pullUpdates();
        this.logProvider.assertContainsThrowablesMatching(0, this.repeat((Throwable)new InvalidEpochException(2L, 1L), SlaveUpdatePuller.LOG_CAP + 1));
    }
}

