/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.test.ha.ClusterRule;

public class ClusterLocksIT {
    private static final long TIMEOUT_MILLIS = 120000L;
    public final ExpectedException expectedException = ExpectedException.none();
    public final ClusterRule clusterRule = new ClusterRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.expectedException).around((TestRule)this.clusterRule);
    private ClusterManager.ManagedCluster cluster;
    private final Label testLabel = Label.label((String)"testLabel");

    @Before
    public void setUp() {
        this.cluster = ((ClusterRule)((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.tx_push_factor, "2")).withInstanceSetting(GraphDatabaseSettings.lock_manager, i -> "community")).startCluster();
    }

    @Test(timeout=120000L)
    public void lockCleanupOnModeSwitch() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.createNodeOnMaster(this.testLabel, master);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit repairKit = this.takeExclusiveLockAndKillSlave(this.testLabel, slave);
        repairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase clusterMaster = this.cluster.getMaster();
        this.takeExclusiveLockOnSameNodeAfterSwitch(this.testLabel, master, clusterMaster);
    }

    @Test
    public void oneOrTheOtherShouldDeadlock() throws Throwable {
        AtomicInteger deadlockCount = new AtomicInteger();
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        Node masterA = this.createNodeOnMaster(this.testLabel, master);
        Node masterB = this.createNodeOnMaster(this.testLabel, master);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction transaction = slave.beginTx();){
            Node slaveA = slave.getNodeById(masterA.getId());
            Node slaveB = slave.getNodeById(masterB.getId());
            CountDownLatch latch = new CountDownLatch(1);
            transaction.acquireWriteLock((PropertyContainer)slaveB);
            Thread masterTx = new Thread(() -> {
                try (Transaction tx = master.beginTx();){
                    tx.acquireWriteLock((PropertyContainer)masterA);
                    latch.countDown();
                    tx.acquireWriteLock((PropertyContainer)masterB);
                }
                catch (DeadlockDetectedException e) {
                    deadlockCount.incrementAndGet();
                }
            });
            masterTx.start();
            latch.await();
            try {
                transaction.acquireWriteLock((PropertyContainer)slaveA);
            }
            catch (DeadlockDetectedException e) {
                deadlockCount.incrementAndGet();
            }
            masterTx.join();
        }
        Assert.assertEquals((long)1L, (long)deadlockCount.get());
    }

    @Test
    public void aPendingMemberShouldBeAbleToServeReads() throws Throwable {
        this.createNodeOnMaster(this.testLabel, this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.cluster.fail(slave, ClusterManager.NetworkFlag.values());
        this.cluster.await(ClusterManager.instanceEvicted(slave));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)slave.getInstanceState());
        for (int i = 0; i < 10; ++i) {
            try (Transaction tx = slave.beginTx();){
                Node single = (Node)Iterables.single((Iterable)slave.getAllNodes());
                Label label = (Label)Iterables.single((Iterable)single.getLabels());
                Assert.assertEquals((Object)this.testLabel, (Object)label);
                tx.success();
                break;
            }
            catch (TransactionTerminatedException e) {
                Thread.sleep(1000L);
                continue;
            }
        }
    }

    private void takeExclusiveLockOnSameNodeAfterSwitch(Label testLabel, HighlyAvailableGraphDatabase master, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        try (Transaction transaction = db.beginTx();){
            Node node = this.getNode(master, testLabel);
            transaction.acquireWriteLock((PropertyContainer)node);
            node.setProperty("key", (Object)"value");
            transaction.success();
        }
    }

    private ClusterManager.RepairKit takeExclusiveLockAndKillSlave(Label testLabel, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        this.takeExclusiveLock(testLabel, db);
        return this.cluster.shutdown(db);
    }

    private Transaction takeExclusiveLock(Label testLabel, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        Transaction transaction = db.beginTx();
        Node node = this.getNode(db, testLabel);
        transaction.acquireWriteLock((PropertyContainer)node);
        return transaction;
    }

    private Node createNodeOnMaster(Label testLabel, HighlyAvailableGraphDatabase master) {
        Node node;
        try (Transaction transaction = master.beginTx();){
            node = master.createNode(new Label[]{testLabel});
            transaction.success();
        }
        return node;
    }

    private Node getNode(HighlyAvailableGraphDatabase db, Label testLabel) throws EntityNotFoundException {
        try (ResourceIterator nodes = db.findNodes(testLabel);){
            Node node = (Node)nodes.stream().findFirst().orElseThrow(() -> new EntityNotFoundException(EntityType.NODE, 0L));
            return node;
        }
    }
}

