/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexCommandSerializationImpl;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexUpdateCommandEncoderTest {
    private static final IndexCommandSerializationImpl SERIALIZATION_UNDER_TEST = IndexCommandSerializationImpl.V1;
    private final InMemoryClosableChannel channel = new InMemoryClosableChannel();
    private final IndexCommandSerialization serialization = new IndexCommandSerialization(this){

        public void writeIndexUpdateCommand(WritableChannel channel, IndexUpdateCommand<?> command) throws IOException {
            SERIALIZATION_UNDER_TEST.writeCommand(channel, command);
        }

        public IndexUpdateCommand<?> readIndexUpdateCommand(ReadableChannel channel) throws IOException {
            return SERIALIZATION_UNDER_TEST.readCommand((IndexCommandSerialization)this, channel);
        }

        public KernelVersion kernelVersion() {
            return KernelVersion.GLORIOUS_FUTURE;
        }
    };

    IndexUpdateCommandEncoderTest() {
    }

    @Test
    void packTokensAdd() throws IOException {
        TokenIndexUpdateCommand command = new TokenIndexUpdateCommand(this.serialization, 123L, 3456789L, ArrayUtils.EMPTY_INT_ARRAY, new int[]{1, 22, 333});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    @Test
    void packTokensChange() throws IOException {
        TokenIndexUpdateCommand command = new TokenIndexUpdateCommand(this.serialization, 123L, 3456789L, new int[]{12345}, new int[]{1, 22, 333});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    @Test
    void packTokensRemove() throws IOException {
        TokenIndexUpdateCommand command = new TokenIndexUpdateCommand(this.serialization, 123L, 3456789L, ArrayUtils.EMPTY_INT_ARRAY, new int[]{1, 22, 333});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    @Test
    void packValuesAdd() throws IOException {
        ValueIndexUpdateCommand command = new ValueIndexUpdateCommand(this.serialization, UpdateMode.ADDED, 123L, 3456789L, null, new Value[]{Values.longValue((long)1L), Values.longValue((long)22L), Values.longValue((long)333L)});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    @Test
    void packValuesChange() throws IOException {
        ValueIndexUpdateCommand command = new ValueIndexUpdateCommand(this.serialization, UpdateMode.CHANGED, 123L, 3456789L, new Value[]{Values.longValue((long)12345L)}, new Value[]{Values.longValue((long)1L), Values.longValue((long)22L), Values.longValue((long)333L)});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    @Test
    void packValuesRemove() throws IOException {
        ValueIndexUpdateCommand command = new ValueIndexUpdateCommand(this.serialization, UpdateMode.REMOVED, 123L, 3456789L, null, new Value[]{Values.longValue((long)1L), Values.longValue((long)22L), Values.longValue((long)333L)});
        SERIALIZATION_UNDER_TEST.writeCommand((WritableChannel)this.channel, (IndexUpdateCommand)command);
        IndexUpdateCommand readCommand = SERIALIZATION_UNDER_TEST.readCommand(this.serialization, (ReadableChannel)this.channel);
        this.assertCommandsEqual((IndexUpdateCommand<?>)command, (IndexUpdateCommand<?>)readCommand);
    }

    private void assertCommandsEqual(IndexUpdateCommand<?> expected, IndexUpdateCommand<?> read) {
        Assertions.assertEquals(expected.getClass(), read.getClass());
        Assertions.assertEquals((Object)expected.getUpdateMode(), (Object)read.getUpdateMode());
        Assertions.assertEquals((long)expected.getIndexId(), (long)read.getIndexId());
        Assertions.assertEquals((long)expected.getEntityId(), (long)read.getEntityId());
        IndexUpdateCommand<?> indexUpdateCommand = expected;
        Objects.requireNonNull(indexUpdateCommand);
        IndexUpdateCommand<?> indexUpdateCommand2 = indexUpdateCommand;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TokenIndexUpdateCommand.class, ValueIndexUpdateCommand.class}, indexUpdateCommand2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TokenIndexUpdateCommand expectedCast = (TokenIndexUpdateCommand)indexUpdateCommand2;
                TokenIndexUpdateCommand readCast = (TokenIndexUpdateCommand)read;
                Assertions.assertArrayEquals((int[])expectedCast.getBefore(), (int[])readCast.getBefore());
                Assertions.assertArrayEquals((int[])expectedCast.getAfter(), (int[])readCast.getAfter());
                break;
            }
            case 1: {
                ValueIndexUpdateCommand expectedCast = (ValueIndexUpdateCommand)indexUpdateCommand2;
                ValueIndexUpdateCommand readCast = (ValueIndexUpdateCommand)read;
                Assertions.assertArrayEquals((Object[])expectedCast.getBefore(), (Object[])readCast.getBefore());
                Assertions.assertArrayEquals((Object[])expectedCast.getAfter(), (Object[])readCast.getAfter());
            }
        }
    }
}

