/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand.encode;

import java.io.IOException;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.indexcommand.encode.PositiveNumberEncoder;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class PositiveNumberEncoderTest {
    @Inject
    private RandomSupport random;
    private final InMemoryClosableChannel channel = new InMemoryClosableChannel();

    PositiveNumberEncoderTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"getSupported"})
    void testPredefinedSupportedValues(long number) throws IOException {
        PositiveNumberEncoder.writeNumber((WritableChannel)this.channel, (long)number);
        long read = PositiveNumberEncoder.readNumber((ReadableChannel)this.channel);
        Assertions.assertEquals((long)number, (long)read);
    }

    @Test
    void testRandomSupportedValues() throws IOException {
        for (int i = 0; i < 10000; ++i) {
            this.channel.reset();
            long number = this.random.nextLong(0x8000000FFL);
            PositiveNumberEncoder.writeNumber((WritableChannel)this.channel, (long)number);
            long read = PositiveNumberEncoder.readNumber((ReadableChannel)this.channel);
            Assertions.assertEquals((long)number, (long)read);
        }
    }

    @Test
    void testRandomValues() throws IOException {
        for (int i = 0; i < 10000; ++i) {
            this.channel.reset();
            long number = this.random.nextLong(0L, -576460752303423488L);
            PositiveNumberEncoder.writeNumber((WritableChannel)this.channel, (long)number);
            long read = PositiveNumberEncoder.readNumber((ReadableChannel)this.channel);
            Assertions.assertEquals((long)number, (long)read);
        }
    }

    static LongStream getSupported() {
        return LongStream.of(0L, 1L, 127L, 128L, 16383L, 16384L, 0x1FFFFFL, 0x200000L, 0xFFFFFFFL, 0x10000000L, 0x7FFFFFFFFL, 0x800000000L);
    }
}

