/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand.encode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.indexcommand.encode.PeekableChannel;
import org.neo4j.internal.indexcommand.encode.ValueStream;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class ValueStreamTest {
    @Inject
    private RandomSupport random;
    private InMemoryClosableChannel channel;

    ValueStreamTest() {
    }

    @BeforeEach
    void setup() {
        int extraBytes = 100;
        this.channel = new InMemoryClosableChannel(32868);
    }

    @ParameterizedTest
    @MethodSource(value={"values"})
    void testValues(Value value) throws IOException {
        ValueStream.write((WritableChannel)this.channel, (AnyValue)value);
        Value readValue = ValueStream.readValue((PeekableChannel)new PeekableChannel((ReadableChannel)this.channel));
        Assertions.assertEquals((Object)value, (Object)readValue);
    }

    @RepeatedTest(value=100)
    void testRandomValues() throws IOException {
        Value value = this.random.nextValue();
        ValueStream.write((WritableChannel)this.channel, (AnyValue)value);
        Value readValue = ValueStream.readValue((PeekableChannel)new PeekableChannel((ReadableChannel)this.channel));
        Assertions.assertEquals((Object)value, (Object)readValue);
    }

    private static Stream<Value> values() {
        return Stream.of(Values.NO_VALUE, Values.byteValue((byte)123), Values.byteValue((byte)127), Values.shortValue((short)123), Values.shortValue((short)Short.MAX_VALUE), Values.intValue((int)123), Values.intValue((int)Integer.MAX_VALUE), Values.longValue((long)123L), Values.longValue((long)Long.MAX_VALUE), Values.floatValue((float)123.123f), Values.doubleValue((double)123.123), Values.stringValue((String)RandomStringUtils.randomAscii((int)4)), Values.stringValue((String)RandomStringUtils.randomAscii((int)14)), Values.stringValue((String)RandomStringUtils.randomAscii((int)24)), Values.stringValue((String)RandomStringUtils.randomAscii((int)48)), Values.stringValue((String)RandomStringUtils.randomAscii((int)96)), Values.stringValue((String)RandomStringUtils.randomAscii((int)188)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)4)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)14)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)24)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)48)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)96)), Values.utf8Value((String)RandomStringUtils.randomAscii((int)188)), Values.temporalValue((Temporal)LocalDate.parse("2021-10-01")), Values.temporalValue((Temporal)LocalDateTime.parse("2021-10-01T10:15")), Values.temporalValue((Temporal)ZonedDateTime.parse("2021-10-01T10:15+01:00[Europe/Stockholm]")), Values.floatArray((float[])new float[]{5.0f, 456789.75f}), Values.doubleArray((double[])new double[]{1.0, 4556789.76}), Values.byteArray((byte[])"Some text".getBytes(StandardCharsets.UTF_8)), Values.longArray((long[])new long[]{12L, 456789L}), Values.intArray((int[])new int[]{123, 456789}), Values.shortArray((short[])new short[]{3, 4789}), Values.booleanArray((boolean[])new boolean[]{false, true, false}), Values.charArray((char[])new char[]{'a', 'c', 'b'}), Values.stringArray((String[])new String[]{"aaa", "red", "\u00f6", "\u0447\u0449\u0446\u044e"}), Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(1987, 5, 7, 7, 8, 9, 10, ZoneOffset.UTC), ZonedDateTime.of(2007, 1, 2, 3, 4, 5, 6, ZoneOffset.UTC)}), Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(1987, 5, 7, 7, 8, 9, 10), LocalDateTime.of(2007, 1, 2, 3, 4, 5, 6)}), Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(1987, 5, 7), LocalDate.of(2007, 1, 2)}), Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(10, 11, 12, 13), LocalTime.of(11, 12, 13, 14), LocalTime.of(12, 13, 14, 15)}), Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(5, 6, 7, 8, ZoneOffset.UTC), OffsetTime.of(6, 7, 8, 1256, ZoneOffset.UTC)}), Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Period)Period.of(5, 0, 0)), DurationValue.duration((long)2L, (long)0L, (long)0L, (long)0L)}), Values.pointArray((PointValue[])new PointValue[]{PointValue.maxPointValueOf((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN), PointValue.minPointValueOf((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D)}), Values.int8Vector((byte[])new byte[]{1, 2}), Values.int16Vector((short[])new short[]{1, 2}), Values.int32Vector((int[])new int[]{1, 2}), Values.int64Vector((long[])new long[]{1L, 2L}), Values.float32Vector((float[])new float[]{1.0f, 2.0f}), Values.float64Vector((double[])new double[]{1.0, 2.0}));
    }
}

