/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.storageengine.api.UpdateMode;

public enum IndexCommandSelector {
    NORMAL{

        @Override
        public <T> T getBefore(IndexUpdateCommand<T> command) {
            return command.getBefore();
        }

        @Override
        public <T> T getAfter(IndexUpdateCommand<T> command) {
            return command.getAfter();
        }

        @Override
        public <T> UpdateMode mode(IndexUpdateCommand<T> command) {
            return command.getUpdateMode();
        }
    }
    ,
    REVERSE{

        @Override
        public <T> T getBefore(IndexUpdateCommand<T> command) {
            return command.getAfter();
        }

        @Override
        public <T> T getAfter(IndexUpdateCommand<T> command) {
            return command.getBefore();
        }

        @Override
        public <T> UpdateMode mode(IndexUpdateCommand<T> command) {
            return switch (command.getUpdateMode()) {
                default -> throw new MatchException(null, null);
                case UpdateMode.ADDED -> UpdateMode.REMOVED;
                case UpdateMode.REMOVED -> UpdateMode.ADDED;
                case UpdateMode.CHANGED -> UpdateMode.CHANGED;
            };
        }
    };


    public abstract <T> T getBefore(IndexUpdateCommand<T> var1);

    public abstract <T> T getAfter(IndexUpdateCommand<T> var1);

    public abstract <T> UpdateMode mode(IndexUpdateCommand<T> var1);
}

