/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.ogm.drivers.http.response.AbstractHttpResponse;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.result.ResultGraphModel;

public class JsonGraphResponseTest {
    @Test
    public void shouldParseColumnsInGraphResponseCorrectly() {
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse(this.graphResultsAndNoErrors());){
            TestCase.assertEquals((int)1, (int)rsp.columns().length);
            TestCase.assertEquals((String)"_0", (String)rsp.columns()[0]);
        }
    }

    @Test
    public void shouldParseColumnsInGraphResponseWithNoColumnsCorrectly() {
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse(this.noGraphResultsAndNoErrors());){
            TestCase.assertEquals((int)1, (int)rsp.columns().length);
            TestCase.assertEquals((String)"_0", (String)rsp.columns()[0]);
        }
    }

    @Test
    public void shouldParseDataInLoadByIdsGraphResponseCorrectly() {
        try (TestGraphHttpResponse rsp = new TestGraphHttpResponse(this.loadByIdsGraphResults());){
            GraphModel graphModel = (GraphModel)rsp.next();
            TestCase.assertNotNull((Object)graphModel);
            Set nodes = graphModel.getNodes();
            TestCase.assertEquals((int)1, (int)nodes.size());
            TestCase.assertEquals((Object)"adam", (Object)((Property)((Node)nodes.iterator().next()).getPropertyList().get(0)).getValue());
            TestCase.assertEquals((int)0, (int)graphModel.getRelationships().size());
            graphModel = (GraphModel)rsp.next();
            TestCase.assertNotNull((Object)graphModel);
            nodes = graphModel.getNodes();
            TestCase.assertEquals((int)2, (int)nodes.size());
            Iterator nodeIterator = nodes.iterator();
            nodeIterator.next();
            TestCase.assertEquals((Object)"GraphAware", (Object)((Property)((Node)nodeIterator.next()).getPropertyList().get(0)).getValue());
            TestCase.assertEquals((int)1, (int)graphModel.getRelationships().size());
            TestCase.assertEquals((String)"EMPLOYED_BY", (String)((Edge)graphModel.getRelationships().iterator().next()).getType());
            for (int i = 0; i < 4; ++i) {
                TestCase.assertNotNull((Object)rsp.next());
            }
            TestCase.assertNull((Object)rsp.next());
        }
    }

    private InputStream graphResultsAndNoErrors() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"381\",\n                \"labels\": [\n                  \"School\"\n                ],\n                \"properties\": {}\n              }\n            ],\n            \"relationships\": []\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"381\",\n                \"labels\": [\n                  \"School\"\n                ],\n                \"properties\": {}\n              }\n            ],\n            \"relationships\": []\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes());
    }

    private InputStream noGraphResultsAndNoErrors() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": []\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\"\n      ],\n      \"data\": []\n    }\n  ],\n  \"errors\": []\n}".getBytes());
    }

    private InputStream loadByIdsGraphResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"506\",\n                \"type\": \"ASSIGNED_TO\",\n                \"startNode\": \"347\",\n                \"endNode\": \"343\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"509\",\n                \"type\": \"CREATED\",\n                \"startNode\": \"344\",\n                \"endNode\": \"346\",\n                \"properties\": {}\n              }\n            ]\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"p\"\n      ],\n      \"data\": [\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"18\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"343\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"343\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"adam\"\n                }\n              },\n              {\n                \"id\": \"347\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 7\",\n                  \"number\": \"7\",\n                  \"title\": \"fake 7\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"506\",\n                \"type\": \"ASSIGNED_TO\",\n                \"startNode\": \"347\",\n                \"endNode\": \"343\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": []\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"26\",\n                \"labels\": [\n                  \"Customer\"\n                ],\n                \"properties\": {\n                  \"name\": \"GraphAware\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"19\",\n                \"type\": \"EMPLOYED_BY\",\n                \"startNode\": \"344\",\n                \"endNode\": \"26\",\n                \"properties\": {}\n              }\n            ]\n          }\n        },\n        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"id\": \"346\",\n                \"labels\": [\n                  \"Issue\"\n                ],\n                \"properties\": {\n                  \"title\": \"fake 1\",\n                  \"number\": \"1\",\n                  \"title\": \"fake 1\"\n                }\n              },\n              {\n                \"id\": \"344\",\n                \"labels\": [\n                  \"User\"\n                ],\n                \"properties\": {\n                  \"firstName\": \"vince\"\n                }\n              }\n            ],\n            \"relationships\": [\n              {\n                \"id\": \"509\",\n                \"type\": \"CREATED\",\n                \"startNode\": \"344\",\n                \"endNode\": \"346\",\n                \"properties\": {}\n              }\n            ]\n          }\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes());
    }

    static class TestGraphHttpResponse
    extends AbstractHttpResponse<ResultGraphModel>
    implements Response<GraphModel> {
        public TestGraphHttpResponse(InputStream inputStream) {
            super(inputStream, ResultGraphModel.class);
        }

        public GraphModel next() {
            ResultGraphModel graphModel = (ResultGraphModel)this.nextDataRecord("graph");
            if (graphModel != null) {
                return graphModel.queryResults();
            }
            return null;
        }

        public void close() {
        }
    }
}

