/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.ogm.drivers.http.response.AbstractHttpResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.ResultRowModel;

public class JsonRowResponseTest {
    @Test
    public void shouldParseColumnsInRowResponseCorrectly() {
        try (TestRowHttpResponse rsp = new TestRowHttpResponse(this.rowResultsAndNoErrors());){
            TestCase.assertEquals((int)1, (int)rsp.columns().length);
            TestCase.assertEquals((String)"collect(p)", (String)rsp.columns()[0]);
        }
    }

    @Test
    public void shouldParseColumnsInRowResponseWithNoColumnsCorrectly() {
        try (TestRowHttpResponse rsp = new TestRowHttpResponse(this.noRowResultsAndNoErrors());){
            TestCase.assertEquals((int)1, (int)rsp.columns().length);
            TestCase.assertEquals((String)"collect(p)", (String)rsp.columns()[0]);
        }
    }

    @Test
    public void shouldParseDataInRowResponseCorrectly() {
        try (TestRowHttpResponse rsp = new TestRowHttpResponse(this.rowResultsAndNoErrors());){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            TestCase.assertNotNull((Object)rowModel);
            Object[] rows = rowModel.getValues();
            TestCase.assertEquals((int)1, (int)rows.length);
            List data = (List)rows[0];
            TestCase.assertEquals((Object)"My Test", ((Map)((List)data.get(0)).get(0)).get("name"));
        }
    }

    @Test
    public void shouldParseDataInCreateRowResponseCorrectly() {
        try (TestRowHttpResponse rsp = new TestRowHttpResponse(this.createRowResults());){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            TestCase.assertNotNull((Object)rowModel);
            Object[] rows = rowModel.getValues();
            TestCase.assertEquals((int)4, (int)rows.length);
            TestCase.assertEquals((Object)388, (Object)rows[0]);
            TestCase.assertEquals((Object)527, (Object)rows[1]);
            TestCase.assertEquals((Object)389, (Object)rows[2]);
            TestCase.assertEquals((Object)528, (Object)rows[3]);
        }
    }

    @Test
    public void shouldParseDataInCustomQueryRowResponseCorrectly() {
        try (TestRowHttpResponse rsp = new TestRowHttpResponse(this.customQueryRowResults());){
            DefaultRowModel rowModel = (DefaultRowModel)rsp.next();
            TestCase.assertNotNull((Object)rowModel);
            Object[] rows = rowModel.getValues();
            TestCase.assertEquals((int)3, (int)rows.length);
            Map obj1 = (Map)rows[0];
            TestCase.assertEquals((Object)"Betty", obj1.get("name"));
            TestCase.assertEquals((int)0, (int)((Map)rows[1]).size());
            TestCase.assertEquals((String)"Peter", (String)((String)rows[2]));
        }
    }

    private InputStream rowResultsAndNoErrors() {
        String s = "{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[[{\"name\": \"My Test\"}]]]}]}],\"errors\": []}";
        return new ByteArrayInputStream("{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[[{\"name\": \"My Test\"}]]]}]}],\"errors\": []}".getBytes());
    }

    private InputStream noRowResultsAndNoErrors() {
        String s = "{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[]]}]}],\"errors\": []}";
        return new ByteArrayInputStream("{\"results\": [{\"columns\": [\"collect(p)\"],\"data\": [{\"row\": [[]]}]}],\"errors\": []}".getBytes());
    }

    private InputStream createRowResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\",\n        \"_1\",\n        \"_2\",\n        \"_3\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            388,\n            527,\n            389,\n            528\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"_0\",\n        \"_1\",\n        \"_2\",\n        \"_3\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            388,\n            527,\n            389,\n            528\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes());
    }

    private InputStream customQueryRowResults() {
        String s = "{\n  \"results\": [\n    {\n      \"columns\": [\n        \"n\",\n        \"r\",\n        \"m.name\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Peter\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Patrick\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Priscilla\"\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}";
        return new ByteArrayInputStream("{\n  \"results\": [\n    {\n      \"columns\": [\n        \"n\",\n        \"r\",\n        \"m.name\"\n      ],\n      \"data\": [\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Peter\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Patrick\"\n          ]\n        },\n        {\n          \"row\": [\n            {\n              \"name\": \"Betty\"\n            },\n            {},\n            \"Priscilla\"\n          ]\n        }\n      ]\n    }\n  ],\n  \"errors\": []\n}".getBytes());
    }

    static class TestRowHttpResponse
    extends AbstractHttpResponse<ResultRowModel>
    implements Response<DefaultRowModel> {
        public TestRowHttpResponse(InputStream inputStream) {
            super(inputStream, ResultRowModel.class);
        }

        public DefaultRowModel next() {
            ResultRowModel rowModel = (ResultRowModel)this.nextDataRecord("row");
            if (rowModel != null) {
                return new DefaultRowModel(rowModel.queryResults(), this.columns());
            }
            return null;
        }

        public void close() {
        }
    }
}

