/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import java.net.URI;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.transaction.TransactionManager;

public abstract class AbstractConfigurableDriver
implements Driver {
    protected DriverConfiguration driverConfig;
    protected TransactionManager transactionManager;

    public void configure(DriverConfiguration config) {
        this.driverConfig = config;
        this.setCredentials();
    }

    public DriverConfiguration getConfiguration() {
        assert (this.driverConfig != null);
        return this.driverConfig;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        assert (transactionManager != null);
        this.transactionManager = transactionManager;
    }

    private void setCredentials() {
        if (this.driverConfig.getCredentials() == null && this.driverConfig.getURI() != null) {
            try {
                URI uri = new URI(this.driverConfig.getURI());
                String authInfo = uri.getUserInfo();
                if (authInfo != null) {
                    String[] parts = uri.getUserInfo().split(":");
                    this.driverConfig.setCredentials(parts[0], parts[1]);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

