/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.ogm.drivers.embedded.response.GraphModelAdapter;
import org.neo4j.ogm.drivers.embedded.response.JsonAdapter;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.DefaultGraphRowModel;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.ResultAdapter;

public class GraphRowModelAdapter
extends JsonAdapter
implements ResultAdapter<Map<String, Object>, GraphRowModel> {
    private GraphModelAdapter graphModelAdapter = new GraphModelAdapter();
    private List<String> columns = new ArrayList<String>();

    public GraphRowModel adapt(Map<String, Object> data) {
        assert (this.columns != null);
        HashSet<Long> nodeIdentities = new HashSet<Long>();
        HashSet<Long> edgeIdentities = new HashSet<Long>();
        DefaultGraphModel graphModel = new DefaultGraphModel();
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator<String> iterator = this.columns.iterator();
        this.adapt(iterator, data, (GraphModel)graphModel, variables, values, nodeIdentities, edgeIdentities);
        DefaultRowModel rowModel = new DefaultRowModel(values.toArray(new Object[0]), variables.toArray(new String[0]));
        return new DefaultGraphRowModel((GraphModel)graphModel, rowModel.getValues());
    }

    private void adapt(Iterator<String> iterator, Map<String, Object> data, GraphModel graphModel, List<String> variables, List<Object> values, Set<Long> nodeIdentities, Set<Long> edgeIdentities) {
        while (iterator.hasNext()) {
            String key = iterator.next();
            variables.add(key);
            Iterable<Object> value = data.get(key);
            if (value.getClass().isArray()) {
                Iterable<Object> collection = value = GraphRowModelAdapter.convertToIterable(value);
                for (Object element : collection) {
                    this.adapt(element, graphModel, values, nodeIdentities, edgeIdentities);
                }
                continue;
            }
            this.adapt(value, graphModel, values, nodeIdentities, edgeIdentities);
        }
    }

    private void adapt(Object element, GraphModel graphModel, List<Object> values, Set<Long> nodeIdentities, Set<Long> edgeIdentities) {
        if (element instanceof Path) {
            this.graphModelAdapter.buildPath((Path)element, graphModel, nodeIdentities, edgeIdentities);
        } else if (element instanceof Node) {
            this.graphModelAdapter.buildNode((Node)element, graphModel, nodeIdentities);
        } else if (element instanceof Relationship) {
            this.graphModelAdapter.buildRelationship((Relationship)element, graphModel, nodeIdentities, edgeIdentities);
        } else {
            values.add(element);
        }
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }
}

