/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.ogm.json.ObjectMapperFactory;

public abstract class JsonAdapter {
    protected static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    protected static final String QUOTE = "\"";
    protected static final String OPEN_BRACE = "{";
    protected static final String CLOSE_BRACE = "}";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String COMMA = ",";
    protected static final String COLON = ":";
    protected static final String SPACE = " ";

    protected static void OPEN_OBJECT(StringBuilder sb) {
        sb.append(OPEN_BRACE);
    }

    protected static void OPEN_OBJECT(String name, StringBuilder sb) {
        sb.append(JsonAdapter.KEY(name));
        sb.append(OPEN_BRACE);
    }

    protected static void CLOSE_OBJECT(StringBuilder sb) {
        sb.append(CLOSE_BRACE);
    }

    protected static void OPEN_ARRAY(String name, StringBuilder sb) {
        sb.append(JsonAdapter.KEY(name));
        sb.append(OPEN_BRACKET);
    }

    protected static void CLOSE_ARRAY(StringBuilder sb) {
        sb.append(CLOSE_BRACKET);
    }

    protected static final String quoted(String s) {
        return QUOTE.concat(s).concat(QUOTE);
    }

    protected static final String KEY(String k) {
        return JsonAdapter.quoted(k).concat(COLON).concat(SPACE);
    }

    protected static final String VALUE(Object v) {
        if (v instanceof String || v instanceof Label) {
            return JsonAdapter.quoted(v.toString());
        }
        return v.toString();
    }

    protected static final String KEY_VALUE(String k, Object v) {
        return JsonAdapter.KEY(k).concat(JsonAdapter.VALUE(v));
    }

    protected static final String KEY_VALUES(String k, Iterable i) {
        String r = JsonAdapter.KEY(k);
        return r.concat(JsonAdapter.convert(i));
    }

    protected static Iterable<Object> convertToIterable(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    protected static String convert(Iterable i) {
        String r = new String();
        r = r.concat(OPEN_BRACKET);
        Iterator iter = i.iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            String s = JsonAdapter.VALUE(v);
            r = r.concat(s);
            if (!iter.hasNext()) continue;
            r = r.concat(COMMA);
        }
        r = r.concat(CLOSE_BRACKET);
        return r;
    }
}

