/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.ogm.result.ResultAdapter;

public class RestModelAdapter
implements ResultAdapter<Map<String, Object>, List<Object>> {
    String[] columns;

    public List<Object> adapt(Map<String, Object> result) {
        ArrayList<Object> queryResult = new ArrayList<Object>(result.size());
        for (String column : this.columns) {
            Object value = result.get(column);
            if (value instanceof Collection) {
                ArrayList<Object> queryResultList = new ArrayList<Object>();
                for (Object data : (List)value) {
                    this.processData(data, queryResultList);
                }
                queryResult.add(queryResultList);
                continue;
            }
            HashMap<String, Object> queryResultRow = new HashMap<String, Object>();
            this.processData(value, queryResult, queryResultRow);
        }
        return queryResult;
    }

    private void processData(Object value, List<Object> queryResultList) {
        HashMap<String, Object> queryResultRow = new HashMap<String, Object>();
        if (value instanceof Node) {
            this.buildNode((Node)value, queryResultRow);
            queryResultList.add(queryResultRow);
            return;
        }
        if (value instanceof Relationship) {
            this.buildRelationship((Relationship)value, queryResultRow);
            queryResultList.add(queryResultRow);
            return;
        }
        queryResultList.add(value);
    }

    private void processData(Object value, List<Object> queryResult, Map<String, Object> queryResultRow) {
        if (value instanceof Node) {
            this.buildNode((Node)value, queryResultRow);
            queryResult.add(queryResultRow);
            return;
        }
        if (value instanceof Relationship) {
            this.buildRelationship((Relationship)value, queryResultRow);
            queryResult.add(queryResultRow);
            return;
        }
        queryResult.add(value);
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    private void buildNode(Node node, Map<String, Object> result) {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        metadata.put("id", Long.valueOf(node.getId()));
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : node.getLabels()) {
            labels.add(label.name());
        }
        metadata.put("labels", labels);
        result.put("metadata", metadata);
        result.put("data", node.getAllProperties());
    }

    private void buildRelationship(Relationship relationship, Map<String, Object> result) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("id", relationship.getId());
        metadata.put("type", relationship.getType().name());
        result.put("metadata", metadata);
        result.put("data", relationship.getAllProperties());
        result.put("start", "/" + relationship.getStartNode().getId());
        result.put("end", "/" + relationship.getEndNode().getId());
    }
}

