/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.drivers.embedded.response.EmbeddedResponse;
import org.neo4j.ogm.drivers.embedded.response.RestModelAdapter;
import org.neo4j.ogm.drivers.embedded.response.StatisticsModelAdapter;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.response.model.DefaultRestModel;
import org.neo4j.ogm.response.model.QueryStatisticsModel;
import org.neo4j.ogm.transaction.TransactionManager;

public class RestModelResponse
extends EmbeddedResponse<DefaultRestModel> {
    private RestModelAdapter restModelAdapter = new RestModelAdapter();
    private final QueryStatisticsModel statisticsModel;

    public RestModelResponse(Result result, TransactionManager transactionManager) {
        super(result, transactionManager);
        this.statisticsModel = new StatisticsModelAdapter().adapt(result);
        this.restModelAdapter.setColumns(this.columns());
    }

    @Override
    public DefaultRestModel next() {
        DefaultRestModel defaultRestModel = new DefaultRestModel(this.parse());
        defaultRestModel.setStats((QueryStatistics)this.statisticsModel);
        return defaultRestModel;
    }

    private Object[] parse() {
        if (this.result.hasNext()) {
            Map data = this.result.next();
            List<Object> adaptedResults = this.restModelAdapter.adapt(data);
            return adaptedResults.toArray();
        }
        return null;
    }
}

