/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.transaction;

import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTransaction
extends AbstractTransaction {
    private final Transaction nativeTransaction;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedTransaction.class);
    private boolean autoCommit;

    public EmbeddedTransaction(TransactionManager transactionManager, Transaction nativeTransaction) {
        super(transactionManager);
        this.nativeTransaction = nativeTransaction;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                this.logger.debug("rolling back native transaction: {}", (Object)this.nativeTransaction);
                this.nativeTransaction.failure();
                this.nativeTransaction.close();
            }
        }
        catch (Exception e) {
            throw new TransactionException(e.getLocalizedMessage());
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        try {
            if (this.transactionManager.canCommit()) {
                this.logger.debug("Committing native transaction: {}", (Object)this.nativeTransaction);
                this.nativeTransaction.success();
                this.nativeTransaction.close();
            } else if (this.transactionManager.isExtended(this.transactionManager.getCurrentTransaction())) {
                throw new TransactionException("Transaction is marked for rollback");
            }
        }
        catch (Exception e) {
            throw new TransactionException(e.getLocalizedMessage());
        }
        finally {
            super.commit();
        }
    }

    public Transaction getNativeTransaction() {
        return this.nativeTransaction;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

