/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.driver;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.drivers.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.http.request.HttpRequest;
import org.neo4j.ogm.drivers.http.transaction.HttpTransaction;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpDriver
extends AbstractConfigurableDriver {
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final Logger logger = LoggerFactory.getLogger(HttpDriver.class);

    public HttpDriver() {
    }

    public HttpDriver(DriverConfiguration configuration) {
        this.configure(configuration);
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            this.logger.warn("Unexpected Exception when closing http client httpClient: ", (Throwable)e);
        }
    }

    public Request request() {
        String url = this.requestUrl();
        return new HttpRequest(this.httpClient, url, this.driverConfig.getCredentials());
    }

    public Transaction newTransaction() {
        String url = this.newTransactionUrl();
        return new HttpTransaction(this.transactionManager, this, url);
    }

    /*
     * Exception decompiling
     */
    public CloseableHttpResponse executeHttpRequest(HttpRequestBase request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String newTransactionUrl() {
        String url = this.transactionEndpoint(this.driverConfig.getURI());
        this.logger.debug("POST {}", (Object)url);
        CloseableHttpResponse response = this.executeHttpRequest((HttpRequestBase)new HttpPost(url));
        Header location = response.getHeaders("Location")[0];
        try {
            response.close();
            return location.getValue();
        }
        catch (IOException e) {
            throw new ResultProcessingException("Failed to execute request: ", (Exception)e);
        }
    }

    private String autoCommitUrl() {
        return this.transactionEndpoint(this.driverConfig.getURI()).concat("/commit");
    }

    private String transactionEndpoint(String server) {
        if (server == null) {
            return null;
        }
        String url = server;
        if (!server.endsWith("/")) {
            url = url + "/";
        }
        return url + "db/data/transaction";
    }

    private String requestUrl() {
        if (this.transactionManager != null) {
            Transaction tx = this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                this.logger.debug("request url {}", (Object)((HttpTransaction)tx).url());
                return ((HttpTransaction)tx).url();
            }
            this.logger.debug("No current transaction, using auto-commit");
        } else {
            this.logger.debug("No transaction manager available, using auto-commit");
        }
        this.logger.debug("request url {}", (Object)this.autoCommitUrl());
        return this.autoCommitUrl();
    }
}

