/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.service.DriverService;

public class DriverServiceTest {
    private DriverConfiguration driverConfiguration = new DriverConfiguration();

    @Test
    public void shouldLoadHttpDriver() {
        this.driverConfiguration.setDriverClassName("org.neo4j.ogm.drivers.http.driver.HttpDriver");
        this.driverConfiguration.setURI("http://neo4j:password@localhost:7474");
        Driver driver = DriverService.load((DriverConfiguration)this.driverConfiguration);
        Assert.assertNotNull((Object)driver);
        driver.close();
    }

    @Test
    public void shouldLoadEmbeddedDriver() {
        this.driverConfiguration.setDriverClassName("org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver");
        this.driverConfiguration.setURI("file:///var/tmp/neo4j.db");
        Driver driver = DriverService.load((DriverConfiguration)this.driverConfiguration);
        Assert.assertNotNull((Object)driver);
        driver.close();
    }

    @Test
    @Ignore
    public void loadLoadBoltDriver() {
        this.driverConfiguration.setDriverClassName("org.neo4j.ogm.drivers.bolt.driver.BoltDriver");
        this.driverConfiguration.setURI("bolt://neo4j:password@localhost");
        Driver driver = DriverService.load((DriverConfiguration)this.driverConfiguration);
        Assert.assertNotNull((Object)driver);
        driver.close();
    }
}

