/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.service.Components;

public class EmbeddedDatabaseTest {
    private static Configuration configuration = new Configuration();
    private static DriverConfiguration driverConfiguration = new DriverConfiguration(configuration);

    @BeforeClass
    public static void setUp() {
        driverConfiguration.setDriverClassName("org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver");
        Components.configure((Configuration)configuration);
    }

    @Test
    public void shouldCreateImpermanentInstanceWhenNoURI() {
        try (EmbeddedDriver driver = new EmbeddedDriver(driverConfiguration);){
            Assert.assertNull((Object)driverConfiguration.getURI());
            Assert.assertNotNull((Object)driver.getGraphDatabaseService());
        }
    }

    @Test
    public void shouldWriteAndRead() {
        try (EmbeddedDriver driver = new EmbeddedDriver(driverConfiguration);){
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            try (Transaction tx = databaseService.beginTx();){
                databaseService.execute("CREATE (n: Node {name: 'node'})");
                Result r = databaseService.execute("MATCH (n) RETURN n");
                Assert.assertTrue((boolean)r.hasNext());
                tx.success();
            }
        }
    }

    @Test
    public void shouldBeAbleToHaveMultipleInstances() {
        try (EmbeddedDriver driver1 = new EmbeddedDriver(driverConfiguration);
             EmbeddedDriver driver2 = new EmbeddedDriver(driverConfiguration);){
            Assert.assertNotNull((Object)driver1.getGraphDatabaseService());
            Assert.assertNotNull((Object)driver2.getGraphDatabaseService());
            Assert.assertFalse((driver1.getGraphDatabaseService() == driver2.getGraphDatabaseService() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)driver1.getGraphDatabaseService().toString().equals(driver2.getGraphDatabaseService().toString()));
        }
    }

    @Test
    public void impermanentInstancesShouldNotShareTheSameDatabase() {
        try (EmbeddedDriver driver1 = new EmbeddedDriver(driverConfiguration);
             EmbeddedDriver driver2 = new EmbeddedDriver(driverConfiguration);){
            GraphDatabaseService db1 = driver1.getGraphDatabaseService();
            GraphDatabaseService db2 = driver2.getGraphDatabaseService();
            try (Transaction tx = db1.beginTx();){
                db1.execute("CREATE (n: Node {name: 'node'})");
                tx.success();
            }
            var8_13 = null;
            try (Transaction tx1 = db1.beginTx();
                 Transaction tx2 = db2.beginTx();){
                Result r1 = db1.execute("MATCH (n) RETURN n");
                Result r2 = db2.execute("MATCH (n) RETURN n");
                Assert.assertTrue((boolean)r1.hasNext());
                Assert.assertFalse((boolean)r2.hasNext());
                tx1.success();
                tx2.success();
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have thrown exception");
        }
    }
}

